/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.LoggingUtils;

public class AclSupportedParser
extends AbstractParser<AclCapabilities> {
    public static final AclSupportedParser INSTANCE = new AclSupportedParser();

    public AclSupportedParser() {
        super("acl-supported");
    }

    @Override
    public AclCapabilities parse(byte[] input, int offset, int len) {
        return this.parse(new ByteArrayBuffer(input, offset, len));
    }

    public AclCapabilities parse(Buffer buffer) {
        return new AclCapabilities(buffer.getInt());
    }

    public static class AclCapabilities
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3118426327336468237L;
        private int capabilities;

        public AclCapabilities() {
            this(0);
        }

        public AclCapabilities(int capabilities) {
            this.capabilities = capabilities;
        }

        public int getCapabilities() {
            return this.capabilities;
        }

        public void setCapabilities(int capabilities) {
            this.capabilities = capabilities;
        }

        public int hashCode() {
            return this.getCapabilities();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return ((AclCapabilities)obj).getCapabilities() == this.getCapabilities();
        }

        public AclCapabilities clone() {
            try {
                return (AclCapabilities)this.getClass().cast(super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Failed to clone " + this.toString() + ": " + e.getMessage(), e);
            }
        }

        public String toString() {
            return Objects.toString(AclCapabilities.decodeAclCapabilities(this.getCapabilities()));
        }

        public static Map<String, Integer> getAclCapabilityNamesMap() {
            return LazyAclCapabilityNameHolder.ACL_NAMES_MAP;
        }

        public static Integer getAclCapabilityValue(String name) {
            if (GenericUtils.isEmpty(name)) {
                return null;
            }
            if (!(name = name.toUpperCase()).startsWith("SSH_ACL_CAP_")) {
                name = name + "SSH_ACL_CAP_";
            }
            Map<String, Integer> map = AclCapabilities.getAclCapabilityNamesMap();
            return map.get(name);
        }

        public static Map<Integer, String> getAclCapabilityValuesMap() {
            return LazyAclCapabilityNameHolder.ACL_VALUES_MAP;
        }

        public static String getAclCapabilityName(int aclCapValue) {
            Map<Integer, String> map = AclCapabilities.getAclCapabilityValuesMap();
            String name = map.get(aclCapValue);
            if (GenericUtils.isEmpty(name)) {
                return Integer.toString(aclCapValue);
            }
            return name;
        }

        public static Set<String> decodeAclCapabilities(int mask) {
            if (mask == 0) {
                return Collections.emptySet();
            }
            TreeSet<String> caps = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            Map<Integer, String> map = AclCapabilities.getAclCapabilityValuesMap();
            map.forEach((value, name) -> {
                if ((mask & value) != 0) {
                    caps.add((String)name);
                }
            });
            return caps;
        }

        public static int constructAclCapabilities(Collection<Integer> maskValues) {
            if (GenericUtils.isEmpty(maskValues)) {
                return 0;
            }
            int mask = 0;
            for (Integer v : maskValues) {
                mask |= v.intValue();
            }
            return mask;
        }

        public static Set<Integer> deconstructAclCapabilities(int mask) {
            if (mask == 0) {
                return Collections.emptySet();
            }
            Map<Integer, String> map = AclCapabilities.getAclCapabilityValuesMap();
            HashSet<Integer> caps = new HashSet<Integer>(map.size());
            for (Integer v : map.keySet()) {
                if ((mask & v) == 0) continue;
                caps.add(v);
            }
            return caps;
        }

        private static class LazyAclCapabilityNameHolder {
            private static final String ACL_CAP_NAME_PREFIX = "SSH_ACL_CAP_";
            private static final Map<Integer, String> ACL_VALUES_MAP = LoggingUtils.generateMnemonicMap(SftpConstants.class, "SSH_ACL_CAP_");
            private static final Map<String, Integer> ACL_NAMES_MAP = Collections.unmodifiableMap(GenericUtils.flipMap(ACL_VALUES_MAP, GenericUtils.caseInsensitiveMap(), false));

            private LazyAclCapabilityNameHolder() {
            }
        }
    }
}

