/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final boolean nestedAnnotationsAsMap;

    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Annotation[] anns;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            types.add(ann.annotationType().getName());
            ++n2;
        }
        return types;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(annotationType)) {
                Annotation[] metaAnns;
                LinkedHashSet<String> types = new LinkedHashSet<String>();
                Annotation[] annotationArray2 = metaAnns = ann.annotationType().getAnnotations();
                int n3 = metaAnns.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation metaAnn = annotationArray2[n4];
                    types.add(metaAnn.annotationType().getName());
                    Annotation[] annotationArray3 = metaAnn.annotationType().getAnnotations();
                    int n5 = annotationArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Annotation metaMetaAnn = annotationArray3[n6];
                        types.add(metaMetaAnn.annotationType().getName());
                        ++n6;
                    }
                    ++n4;
                }
                return types;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] metaAnns;
            Annotation ann = annotationArray[n2];
            Annotation[] annotationArray2 = metaAnns = ann.annotationType().getAnnotations();
            int n3 = metaAnns.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation metaAnn = annotationArray2[n4];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                Annotation[] annotationArray3 = metaAnn.annotationType().getAnnotations();
                int n5 = annotationArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation metaMetaAnn = annotationArray3[n6];
                    if (metaMetaAnn.annotationType().getName().equals(annotationType)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation metaAnn = annotationArray2[n4];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.getIntrospectedClass().getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(annotationType)) {
                return AnnotationUtils.getAnnotationAttributes(ann, classValuesAsString, this.nestedAnnotationsAsMap);
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation metaAnn = annotationArray2[n4];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return AnnotationUtils.getAnnotationAttributes(metaAnn, classValuesAsString, this.nestedAnnotationsAsMap);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        Method[] methods;
        Method[] methodArray = methods = this.getIntrospectedClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = method.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray[n4];
                if (ann.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
                int n5 = annotationArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation metaAnn = annotationArray2[n6];
                    if (metaAnn.annotationType().getName().equals(annotationType)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        Method[] methods = this.getIntrospectedClass().getDeclaredMethods();
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = method.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray[n4];
                if (ann.annotationType().getName().equals(annotationType)) {
                    annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
                    break;
                }
                Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
                int n5 = annotationArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation metaAnn = annotationArray2[n6];
                    if (metaAnn.annotationType().getName().equals(annotationType)) {
                        annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
                        break;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return annotatedMethods;
    }
}

