/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CommandTracker
extends ServiceTracker<Object, List<Command>> {
    final SessionFactory sessionFactory;

    public CommandTracker(SessionFactory sessionFactory, BundleContext context) throws InvalidSyntaxException {
        super(context, CommandTracker.createFilter(context), null);
        this.sessionFactory = sessionFactory;
    }

    private static Filter createFilter(BundleContext context) throws InvalidSyntaxException {
        return context.createFilter(String.format("(&(%s=*)(%s=*)(!(%s=%s))(!(%s=%s)))", "osgi.command.scope", "osgi.command.function", "objectClass", "org.apache.felix.gogo.commands.CommandWithAction", "objectClass", "org.apache.karaf.shell.commands.CommandWithAction"));
    }

    public List<Command> addingService(final ServiceReference<Object> reference) {
        final String scope = reference.getProperty("osgi.command.scope").toString();
        Object function = reference.getProperty("osgi.command.function");
        ArrayList<String> names = new ArrayList<String>();
        if (function.getClass().isArray()) {
            for (Object f : (Object[])function) {
                names.add(f.toString());
            }
        } else {
            names.add(function.toString());
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (final String name : names) {
            final CommandProxy target = new CommandProxy(this.context, reference, name);
            Command command = new Command(){

                @Override
                public String getScope() {
                    return scope;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getDescription() {
                    Object property = reference.getProperty("osgi.command.description");
                    if (property != null) {
                        return property.toString();
                    }
                    return this.getName();
                }

                @Override
                public Completer getCompleter(boolean scoped) {
                    return null;
                }

                @Override
                public Parser getParser() {
                    return null;
                }

                @Override
                public Object execute(Session session, List<Object> arguments) throws Exception {
                    CommandSession commandSession = (CommandSession)session.get(".commandSession");
                    return target.execute(commandSession, arguments);
                }
            };
            this.sessionFactory.getRegistry().register(command);
            commands.add(command);
        }
        return commands;
    }

    public void removedService(ServiceReference<Object> reference, List<Command> commands) {
        for (Command command : commands) {
            this.sessionFactory.getRegistry().unregister(command);
        }
    }
}

