/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheExpressionRootObject;
import org.springframework.cache.interceptor.LazyParamAwareEvaluationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionEvaluator {
    public static final Object NO_RESULT = new Object();
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final Map<String, Expression> keyCache = new ConcurrentHashMap<String, Expression>(64);
    private final Map<String, Expression> conditionCache = new ConcurrentHashMap<String, Expression>(64);
    private final Map<String, Expression> unlessCache = new ConcurrentHashMap<String, Expression>(64);
    private final Map<String, Method> targetMethodCache = new ConcurrentHashMap<String, Method>(64);

    ExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(Collection<Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass) {
        return this.createEvaluationContext(caches, method, args, target, targetClass, NO_RESULT);
    }

    public EvaluationContext createEvaluationContext(Collection<Cache> caches, Method method, Object[] args, Object target, Class<?> targetClass, Object result) {
        CacheExpressionRootObject rootObject = new CacheExpressionRootObject(caches, method, args, target, targetClass);
        LazyParamAwareEvaluationContext evaluationContext = new LazyParamAwareEvaluationContext(rootObject, this.paramNameDiscoverer, method, args, targetClass, this.targetMethodCache);
        if (result != NO_RESULT) {
            evaluationContext.setVariable("result", result);
        }
        return evaluationContext;
    }

    public Object key(String keyExpression, Method method, EvaluationContext evalContext) {
        return this.getExpression(this.keyCache, keyExpression, method).getValue(evalContext);
    }

    public boolean condition(String conditionExpression, Method method, EvaluationContext evalContext) {
        return (Boolean)this.getExpression(this.conditionCache, conditionExpression, method).getValue(evalContext, Boolean.TYPE);
    }

    public boolean unless(String unlessExpression, Method method, EvaluationContext evalContext) {
        return (Boolean)this.getExpression(this.unlessCache, unlessExpression, method).getValue(evalContext, Boolean.TYPE);
    }

    private Expression getExpression(Map<String, Expression> cache, String expression, Method method) {
        String key = this.toString(method, expression);
        Expression rtn = cache.get(key);
        if (rtn == null) {
            rtn = this.parser.parseExpression(expression);
            cache.put(key, rtn);
        }
        return rtn;
    }

    private String toString(Method method, String expression) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getDeclaringClass().getName());
        sb.append("#");
        sb.append(method.toString());
        sb.append("#");
        sb.append(expression);
        return sb.toString();
    }
}

