/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.repository;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public abstract class UrlLoader {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String GZIP = "gzip";
    private final String url;
    private final long expiration;
    private long lastModified;
    private long lastChecked;

    public UrlLoader(String url, long expiration) {
        this.url = url;
        this.expiration = expiration;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAndLoadCache() {
        boolean bl;
        block13: {
            long lm;
            long time = System.currentTimeMillis();
            if (this.lastChecked > 0L && (this.expiration < 0L || time - this.lastChecked < this.expiration)) {
                return false;
            }
            URLConnection connection = new URL(this.url).openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection con = (HttpURLConnection)connection;
                if (this.lastModified > 0L) {
                    con.setIfModifiedSince(this.lastModified);
                }
                con.setRequestProperty(HEADER_ACCEPT_ENCODING, GZIP);
                int rc = con.getResponseCode();
                if (rc == 304) {
                    this.lastChecked = time;
                    return false;
                }
                if (rc != 200) {
                    throw new IOException("Unexpected http response loading " + this.url + " : " + rc + " " + con.getResponseMessage());
                }
            }
            if ((lm = connection.getLastModified()) > 0L && lm <= this.lastModified) {
                this.lastChecked = time;
                return false;
            }
            FilterInputStream is = null;
            try {
                is = new BufferedInputStream(connection.getInputStream());
                ((InputStream)is).mark(512);
                int b0 = ((InputStream)is).read();
                int b1 = ((InputStream)is).read();
                ((InputStream)is).reset();
                if (b0 == 31 && b1 == 139) {
                    is = new GZIPInputStream(is);
                }
                boolean r = this.doRead(is);
                this.lastModified = lm;
                this.lastChecked = time;
                bl = r;
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)is).close();
        }
        return bl;
    }

    protected abstract boolean doRead(InputStream var1) throws IOException;
}

