/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class ChannelForwardedX11
extends AbstractClientChannel {
    private final IoSession serverSession;

    public ChannelForwardedX11(IoSession serverSession) {
        super("x11");
        this.serverSession = serverSession;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.lock);
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        InetAddress remoteAddress = remote.getAddress();
        String remoteHost = remoteAddress.getHostAddress();
        Window wLocal = this.getLocalWindow();
        Buffer buffer = session.createBuffer((byte)90, remoteHost.length() + this.type.length() + 32);
        buffer.putString(this.type);
        buffer.putInt(this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        buffer.putString(remoteHost);
        buffer.putInt(remote.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (ClientChannel.Streaming.Async.equals((Object)this.streaming)) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        Window wLocal = this.getLocalWindow();
        wLocal.consumeAndCheck(len);
        this.serverSession.write(ByteArrayBuffer.getCompactClone(data, off, (int)len));
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        this.serverSession.close(false);
    }
}

