/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.syncope;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.felix.utils.json.JSONParser;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeLoginModule
extends AbstractKarafLoginModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeLoginModule.class);
    public static final String ADDRESS = "address";
    public static final String VERSION = "version";
    public static final String USE_ROLES_FOR_SYNCOPE2 = "useRolesForSyncope2";
    public static final String ADMIN_USER = "admin.user";
    public static final String ADMIN_PASSWORD = "admin.password";
    private String address;
    private String version;
    private boolean useRolesForSyncope2;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.address = (String)options.get(ADDRESS);
        this.version = (String)options.get(VERSION);
        if (options.containsKey(USE_ROLES_FOR_SYNCOPE2)) {
            this.useRolesForSyncope2 = Boolean.parseBoolean((String)options.get(USE_ROLES_FOR_SYNCOPE2));
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean version2;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioException) {
            throw new LoginException(ioException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to obtain information from user.");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        this.principals = new HashSet();
        LOGGER.debug("Authenticate user {} on Syncope located {}", (Object)this.user, (Object)this.address);
        DefaultHttpClient client = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, password);
        client.getCredentialsProvider().setCredentials(AuthScope.ANY, creds);
        HttpGet get = new HttpGet(this.address + "/users/self");
        boolean bl = version2 = this.version != null && (this.version.equals("2.x") || this.version.equals("2"));
        if (version2) {
            get.setHeader("Content-Type", "application/json");
        } else {
            get.setHeader("Content-Type", "application/xml");
        }
        List<Object> roles = new ArrayList();
        try {
            CloseableHttpResponse response = client.execute(get);
            LOGGER.debug("Syncope HTTP response status code: {}", (Object)response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.warn("User {} not authenticated", (Object)this.user);
                return false;
            }
            LOGGER.debug("User {} authenticated", (Object)this.user);
            LOGGER.debug("Populating principals with user");
            this.principals.add(new UserPrincipal(this.user));
            LOGGER.debug("Retrieving user {} roles", (Object)this.user);
            String string = EntityUtils.toString(response.getEntity());
            roles = version2 ? this.extractingRolesSyncope2(string) : this.extractingRolesSyncope1(string);
        }
        catch (Exception e) {
            LOGGER.error("User {} authentication failed", (Object)this.user, (Object)e);
            throw new LoginException("User " + this.user + " authentication failed: " + e.getMessage());
        }
        LOGGER.debug("Populating principals with roles");
        for (String string : roles) {
            this.principals.add(new RolePrincipal(string));
        }
        return true;
    }

    protected List<String> extractingRolesSyncope1(String response) throws Exception {
        int index;
        ArrayList<String> roles = new ArrayList<String>();
        if (response != null && !response.isEmpty() && (index = response.indexOf("<memberships>")) != -1) {
            response = response.substring(index + "<memberships>".length());
            index = response.indexOf("</memberships>");
            response = response.substring(0, index);
            index = response.indexOf("<roleName>");
            while (index != -1) {
                int end = (response = response.substring(index + "<roleName>".length())).indexOf("</roleName>");
                if (end == -1) {
                    index = -1;
                }
                String role = response.substring(0, end);
                roles.add(role);
                response = response.substring(end + "</roleName>".length());
                index = response.indexOf("<roleName>");
            }
        }
        return roles;
    }

    protected List<String> extractingRolesSyncope2(String response) throws Exception {
        ArrayList<String> roles = new ArrayList<String>();
        if (response != null && !response.isEmpty()) {
            JSONParser parser = new JSONParser(response);
            if (this.useRolesForSyncope2) {
                return (List)parser.getParsed().get("roles");
            }
            List memberships = (List)parser.getParsed().get("memberships");
            if (memberships != null) {
                for (Map membership : memberships) {
                    if (!membership.containsKey("groupName")) continue;
                    roles.add((String)membership.get("groupName"));
                }
            }
        }
        return roles;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

