/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import org.springframework.messaging.Message;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.simp.SimpMessageTypeMessageCondition;

public class SimpMessageMappingInfo
implements MessageCondition<SimpMessageMappingInfo> {
    private final SimpMessageTypeMessageCondition messageTypeMessageCondition;
    private final DestinationPatternsMessageCondition destinationConditions;

    public SimpMessageMappingInfo(SimpMessageTypeMessageCondition messageTypeMessageCondition, DestinationPatternsMessageCondition destinationConditions) {
        this.messageTypeMessageCondition = messageTypeMessageCondition;
        this.destinationConditions = destinationConditions;
    }

    public SimpMessageTypeMessageCondition getMessageTypeMessageCondition() {
        return this.messageTypeMessageCondition;
    }

    public DestinationPatternsMessageCondition getDestinationConditions() {
        return this.destinationConditions;
    }

    @Override
    public SimpMessageMappingInfo combine(SimpMessageMappingInfo other) {
        SimpMessageTypeMessageCondition typeCond = this.getMessageTypeMessageCondition().combine(other.getMessageTypeMessageCondition());
        DestinationPatternsMessageCondition destCond = this.destinationConditions.combine(other.getDestinationConditions());
        return new SimpMessageMappingInfo(typeCond, destCond);
    }

    @Override
    public SimpMessageMappingInfo getMatchingCondition(Message<?> message) {
        Object typeCond = this.messageTypeMessageCondition.getMatchingCondition((Message)message);
        if (typeCond == null) {
            return null;
        }
        Object destCond = this.destinationConditions.getMatchingCondition((Message)message);
        if (destCond == null) {
            return null;
        }
        return new SimpMessageMappingInfo((SimpMessageTypeMessageCondition)typeCond, (DestinationPatternsMessageCondition)destCond);
    }

    @Override
    public int compareTo(SimpMessageMappingInfo other, Message<?> message) {
        int result = this.messageTypeMessageCondition.compareTo(other.messageTypeMessageCondition, message);
        if (result != 0) {
            return result;
        }
        result = this.destinationConditions.compareTo(other.destinationConditions, message);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof SimpMessageMappingInfo) {
            SimpMessageMappingInfo other = (SimpMessageMappingInfo)obj;
            return this.destinationConditions.equals(other.destinationConditions) && this.messageTypeMessageCondition.equals(other.messageTypeMessageCondition);
        }
        return false;
    }

    public int hashCode() {
        return this.destinationConditions.hashCode() * 31 + this.messageTypeMessageCondition.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(this.destinationConditions);
        builder.append(",messageType=").append(this.messageTypeMessageCondition);
        builder.append('}');
        return builder.toString();
    }
}

