/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.completers;

import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.karaf.shell.api.console.Candidate;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;

public class UriCompleter
implements Completer {
    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void completeCandidates(Session session, CommandLine commandLine, List<Candidate> candidates) {
        String arg = commandLine.getCursorArgument();
        if (arg != null) {
            if (arg.startsWith("mvn:")) {
                this.maven(session, commandLine, candidates);
            } else if (arg.startsWith("file:")) {
                this.file(session, commandLine, candidates);
            }
        }
    }

    private void file(Session session, CommandLine commandLine, List<Candidate> candidates) {
        block21: {
            String buffer = commandLine.getCursorArgument();
            String path = buffer.substring("file:".length(), commandLine.getArgumentPosition());
            String rem = "";
            try {
                Path dir;
                if (path.length() == 0) {
                    for (Path root : FileSystems.getDefault().getRootDirectories()) {
                        candidates.add(new Candidate(root.toString(), false));
                    }
                    dir = Paths.get(".", new String[0]);
                } else {
                    dir = Paths.get(this.decode(path), new String[0]);
                    if (!path.endsWith("/")) {
                        rem = dir.getFileName().toString();
                        if ((dir = dir.getParent()) == null) {
                            dir = Paths.get(".", new String[0]);
                        }
                    }
                }
                if (!Files.isDirectory(dir, new LinkOption[0])) break block21;
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, rem + "*");){
                    for (Path child : paths) {
                        String name = this.encode(child.getFileName().toString());
                        boolean isDir = Files.isDirectory(child, new LinkOption[0]);
                        if (isDir) {
                            name = name + "/";
                        }
                        String dirstr = dir.endsWith("/") ? dir.toString() : dir.toString() + "/";
                        candidates.add(new Candidate("file:" + dirstr + name, !isDir));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String encode(String s) {
        return s.replaceAll(" ", "%20");
    }

    private String decode(String s) {
        return s.replaceAll("%20", " ");
    }

    private void maven(Session session, CommandLine commandLine, List<Candidate> candidates) {
        block50: {
            String repo = System.getProperty("user.home") + "/.m2/repository";
            String buffer = commandLine.getCursorArgument();
            String mvn = buffer.substring("mvn:".length(), commandLine.getArgumentPosition());
            String rem = "";
            try {
                String[] parts = mvn.split("/");
                if (parts.length == 0 || parts.length == 1 && !mvn.endsWith("/")) {
                    int i;
                    String[] stringArray;
                    String known = "";
                    String group = "";
                    if (parts.length > 0) {
                        stringArray = parts[0].split("\\.");
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "";
                    }
                    String[] dirs = stringArray;
                    if (parts.length > 0 && parts[0].endsWith(".")) {
                        for (i = 0; i < dirs.length; ++i) {
                            known = known + dirs[i] + "/";
                            group = group + dirs[i] + ".";
                        }
                    } else {
                        for (i = 0; i < dirs.length - 1; ++i) {
                            known = known + dirs[i] + "/";
                            group = group + dirs[i] + ".";
                        }
                        rem = dirs[dirs.length - 1];
                    }
                    Path rep = Paths.get(repo, new String[0]);
                    Path dir = rep.resolve(known);
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, rem + "*");){
                        for (Path path : paths) {
                            if (!Files.isDirectory(path, new LinkOption[0])) continue;
                            String name = path.getFileName().toString();
                            candidates.add(new Candidate("mvn:" + group + name, false));
                        }
                    }
                    rem = group + rem;
                    break block50;
                }
                if (parts.length == 1 || parts.length == 2 && !mvn.endsWith("/")) {
                    rem = parts.length > 1 ? parts[1] : "";
                    Path dir = Paths.get(repo + "/" + parts[0].replace(".", "/"), new String[0]);
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, rem + "*");){
                        for (Path path : paths) {
                            if (!Files.isDirectory(path, new LinkOption[0])) continue;
                            String name = path.getFileName().toString();
                            candidates.add(new Candidate("mvn:" + parts[0] + "/" + name, false));
                        }
                        break block50;
                    }
                }
                if (parts.length != 2 && (parts.length != 3 || mvn.endsWith("/"))) break block50;
                rem = parts.length > 2 ? parts[2] : "";
                Path dir = Paths.get(repo + "/" + parts[0].replace(".", "/") + "/" + parts[1], new String[0]);
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, rem + "*");){
                    for (Path path : paths) {
                        if (!Files.isDirectory(path, new LinkOption[0])) continue;
                        String name = path.getFileName().toString();
                        candidates.add(new Candidate("mvn:" + parts[0] + "/" + parts[1] + "/" + name, true));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

