/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ops4j.pax.logging.logback.internal.LogReaderServiceAccess;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogReaderServiceImpl
implements LogReaderService {
    private List<LogListener> m_listeners = new CopyOnWriteArrayList<LogListener>();
    private final Deque<LogEntry> m_entries;
    private int m_maxEntries;

    public LogReaderServiceImpl(int maxEntries) {
        this.m_maxEntries = maxEntries;
        this.m_entries = new LinkedList<LogEntry>();
    }

    public void addLogListener(LogListener logListener) {
        this.m_listeners.add(logListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.m_listeners.remove(logListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getLog() {
        Deque<LogEntry> deque = this.m_entries;
        synchronized (deque) {
            return Collections.enumeration(new ArrayList<LogEntry>(this.m_entries));
        }
    }

    private void cleanUp() {
        while (this.m_entries.size() > this.m_maxEntries) {
            this.m_entries.removeLast();
        }
    }

    private void fire(LogListener listener, LogEntry entry) {
        try {
            listener.logged(entry);
        }
        catch (Throwable e) {
            System.err.println("'" + listener + "' is removed as a LogListener, since it threw an exception.");
            this.removeLogListener(listener);
        }
    }

    LogReaderServiceAccess getAccessDelegate() {
        return new LogReaderServiceAccess(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fireEvent(LogEntry entry) {
                Deque deque = LogReaderServiceImpl.this.m_entries;
                synchronized (deque) {
                    LogReaderServiceImpl.this.m_entries.addFirst(entry);
                    LogReaderServiceImpl.this.cleanUp();
                }
                for (LogListener listener : LogReaderServiceImpl.this.m_listeners) {
                    LogReaderServiceImpl.this.fire(listener, entry);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setMaxEntries(int maxSize) {
                Deque deque = LogReaderServiceImpl.this.m_entries;
                synchronized (deque) {
                    LogReaderServiceImpl.this.m_maxEntries = maxSize;
                }
            }
        };
    }
}

