/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import org.springframework.jca.endpoint.AbstractMessageEndpointFactory;

public class JmsMessageEndpointFactory
extends AbstractMessageEndpointFactory {
    private MessageListener messageListener;

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    protected MessageListener getMessageListener() {
        return this.messageListener;
    }

    protected AbstractMessageEndpointFactory.AbstractMessageEndpoint createEndpointInternal() throws UnavailableException {
        return new JmsMessageEndpoint();
    }

    public static class JmsResourceException
    extends RuntimeException {
        public JmsResourceException(ResourceException cause) {
            super((Throwable)cause);
        }
    }

    private class JmsMessageEndpoint
    extends AbstractMessageEndpointFactory.AbstractMessageEndpoint
    implements MessageListener {
        private JmsMessageEndpoint() {
            super((AbstractMessageEndpointFactory)JmsMessageEndpointFactory.this);
        }

        public void onMessage(Message message) {
            boolean applyDeliveryCalls;
            boolean bl = applyDeliveryCalls = !this.hasBeforeDeliveryBeenCalled();
            if (applyDeliveryCalls) {
                try {
                    this.beforeDelivery(null);
                }
                catch (ResourceException ex) {
                    throw new JmsResourceException(ex);
                }
            }
            try {
                JmsMessageEndpointFactory.this.messageListener.onMessage(message);
            }
            catch (RuntimeException ex) {
                this.onEndpointException(ex);
                throw ex;
            }
            catch (Error err) {
                this.onEndpointException(err);
                throw err;
            }
            finally {
                if (applyDeliveryCalls) {
                    try {
                        this.afterDelivery();
                    }
                    catch (ResourceException ex) {
                        throw new JmsResourceException(ex);
                    }
                }
            }
        }

        protected ClassLoader getEndpointClassLoader() {
            return JmsMessageEndpointFactory.this.messageListener.getClass().getClassLoader();
        }
    }
}

