/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import shaded.org.apache.commons.io.FileUtils;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.commons.io.input.TailerListener;

public class Tailer
implements Runnable {
    private final File file;
    private final long delay;
    private final boolean end;
    private final TailerListener listener;
    private volatile boolean run = true;

    public Tailer(File file, TailerListener listener) {
        this(file, listener, 1000L);
    }

    public Tailer(File file, TailerListener listener, long delay) {
        this(file, listener, delay, false);
    }

    public Tailer(File file, TailerListener listener, long delay, boolean end) {
        this.file = file;
        this.delay = delay;
        this.end = end;
        this.listener = listener;
        listener.init(this);
    }

    public static Tailer create(File file, TailerListener listener, long delay, boolean end) {
        Tailer tailer = new Tailer(file, listener, delay, end);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static Tailer create(File file, TailerListener listener, long delay) {
        return Tailer.create(file, listener, delay, false);
    }

    public static Tailer create(File file, TailerListener listener) {
        return Tailer.create(file, listener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    public long getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RandomAccessFile reader = null;
        try {
            long last = 0L;
            long position = 0L;
            while (this.run && reader == null) {
                try {
                    reader = new RandomAccessFile(this.file, "r");
                }
                catch (FileNotFoundException e) {
                    this.listener.fileNotFound();
                }
                if (reader == null) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                position = this.end ? this.file.length() : 0L;
                last = System.currentTimeMillis();
                reader.seek(position);
            }
            while (this.run) {
                long length = this.file.length();
                if (length < position) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile save = reader;
                        reader = new RandomAccessFile(this.file, "r");
                        position = 0L;
                        IOUtils.closeQuietly(save);
                    }
                    catch (FileNotFoundException e) {
                        this.listener.fileNotFound();
                    }
                    continue;
                }
                if (length > position) {
                    last = System.currentTimeMillis();
                    position = this.readLines(reader);
                } else if (FileUtils.isFileNewer(this.file, last)) {
                    position = 0L;
                    reader.seek(position);
                    last = System.currentTimeMillis();
                    position = this.readLines(reader);
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Exception e) {
            this.listener.handle(e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile reader) throws IOException {
        long pos = reader.getFilePointer();
        String line = this.readLine(reader);
        while (line != null) {
            pos = reader.getFilePointer();
            this.listener.handle(line);
            line = this.readLine(reader);
        }
        reader.seek(pos);
        return pos;
    }

    private String readLine(RandomAccessFile reader) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        boolean seenCR = false;
        block4: while ((ch = reader.read()) != -1) {
            switch (ch) {
                case 10: {
                    return sb.toString();
                }
                case 13: {
                    seenCR = true;
                    continue block4;
                }
            }
            if (seenCR) {
                sb.append('\r');
                seenCR = false;
            }
            sb.append((char)ch);
        }
        return null;
    }
}

