/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintStateMBean;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.osgi.service.blueprint.container.BlueprintEvent;

public class OSGiBlueprintEvent
implements TransferObject {
    private long bundleId;
    private long extenderBundleId;
    private int eventType;
    private boolean replay;
    private long timestamp;
    private String[] dependencies;
    private String exceptionMessage;

    public OSGiBlueprintEvent(BlueprintEvent event) {
        this(event.getBundle().getBundleId(), event.getExtenderBundle().getBundleId(), event.getType(), event.isReplay(), event.getTimestamp(), event.getDependencies(), event.getCause() == null ? null : event.getCause().getMessage());
    }

    public OSGiBlueprintEvent(CompositeData data) {
        this((Long)data.get("BundleId"), (Long)data.get("ExtenderBundleId"), (Integer)data.get("EventType"), (Boolean)data.get("Replay"), (Long)data.get("Timestamp"), (String[])data.get("Dependencies"), (String)data.get("ExceptionMessage"));
    }

    public OSGiBlueprintEvent(long bundleId, long extenderBundleId, int eventType, boolean replay, long timestamp, String[] dependencies, String exceptionMessage) {
        this.bundleId = bundleId;
        this.extenderBundleId = extenderBundleId;
        this.eventType = eventType;
        this.replay = replay;
        this.timestamp = timestamp;
        this.dependencies = dependencies;
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("BundleId", this.bundleId);
        items.put("ExtenderBundleId", this.extenderBundleId);
        items.put("EventType", this.eventType);
        items.put("Replay", this.replay);
        items.put("Timestamp", this.timestamp);
        items.put("Dependencies", this.dependencies);
        items.put("ExceptionMessage", this.exceptionMessage);
        try {
            return new CompositeDataSupport(BlueprintStateMBean.OSGI_BLUEPRINT_EVENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form blueprint event open data", e);
        }
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public long getExtenderBundleId() {
        return this.extenderBundleId;
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

