/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command.completers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.config.core.impl.MetaServiceCaller;
import org.apache.karaf.config.core.impl.MetatypeCallable;
import org.apache.karaf.shell.api.action.lifecycle.Init;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

@Service
public class MetaCompleter
implements Completer,
BundleListener {
    private final StringsCompleter delegate = new StringsCompleter();
    @Reference
    BundleContext context;

    @Init
    public void init() {
        this.context.registerService(BundleListener.class, (Object)this, null);
        this.updateMeta();
    }

    public synchronized int complete(Session session, CommandLine commandLine, List<String> candidates) {
        return this.delegate.complete(session, commandLine, candidates);
    }

    public void bundleChanged(BundleEvent event) {
        this.updateMeta();
    }

    private synchronized void updateMeta() {
        List<String> pids = MetaServiceCaller.withMetaTypeService(this.context, new MetatypeCallable<List<String>>(){

            @Override
            public List<String> callWith(MetaTypeService metatypeService) {
                Bundle[] bundles;
                ArrayList<String> pids = new ArrayList<String>();
                for (Bundle bundle : bundles = MetaCompleter.this.context.getBundles()) {
                    MetaTypeInformation info = metatypeService.getMetaTypeInformation(bundle);
                    if (info == null) continue;
                    if (info.getFactoryPids() != null) {
                        pids.addAll(Arrays.asList(info.getFactoryPids()));
                    }
                    if (info.getPids() == null) continue;
                    pids.addAll(Arrays.asList(info.getPids()));
                }
                return pids;
            }
        });
        if (pids != null) {
            this.delegate.getStrings().clear();
            this.delegate.getStrings().addAll(pids);
        }
    }
}

