/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.InstalledRepoNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="repo-remove", description="Removes the specified repository features service.")
@Service
public class RepoRemoveCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="repository", description="Name or url of the repository to remove.", required=true, multiValued=false)
    @Completion(value=InstalledRepoNameCompleter.class)
    private String repository;
    @Option(name="-u", aliases={"--uninstall-all"}, description="Uninstall all features from the repository", required=false, multiValued=false)
    private boolean uninstall;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        ArrayList<URI> uris = new ArrayList<URI>();
        Pattern pattern = Pattern.compile(this.repository);
        for (Repository r : featuresService.listRepositories()) {
            if (r.getName() != null && !r.getName().isEmpty()) {
                Matcher nameMatcher = pattern.matcher(r.getName());
                if (nameMatcher.matches()) {
                    uris.add(r.getURI());
                    continue;
                }
                Matcher uriMatcher = pattern.matcher(r.getURI().toString());
                if (!uriMatcher.matches()) continue;
                uris.add(r.getURI());
                continue;
            }
            Matcher uriMatcher = pattern.matcher(r.getURI().toString());
            if (!uriMatcher.matches()) continue;
            uris.add(r.getURI());
        }
        for (URI uri : uris) {
            System.out.println("Removing features repository " + uri);
            featuresService.removeRepository(uri, this.uninstall);
        }
    }
}

