/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.ansi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;

public class AnsiSplitter {
    public static List<String> splitLines(String text, int maxLength, int tabs) throws IOException {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        sb.tabs(tabs);
        sb.appendAnsi(text);
        return sb.columnSplitLength(maxLength).stream().map(AttributedCharSequence::toAnsi).collect(Collectors.toList());
    }

    public static String substring(String text, int begin, int end, int tabs) throws IOException {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        sb.tabs(tabs);
        sb.appendAnsi(text);
        return sb.columnSubSequence(begin, end).toAnsi();
    }

    public static int length(String text, int tabs) throws IOException {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        sb.tabs(tabs);
        sb.appendAnsi(text);
        return sb.columnLength();
    }

    public static String cut(String text, int maxLength, int tabs) throws IOException {
        return AnsiSplitter.splitLines(text, maxLength, tabs).get(0);
    }

    public static AnsiBufferedReader window(InputStream is, int begin, int end, int tabs) throws IOException {
        AnsiBufferedReader reader = new AnsiBufferedReader(is, begin, end, Integer.MAX_VALUE);
        reader.setTabs(tabs);
        return reader;
    }

    public static AnsiBufferedReader splitter(InputStream is, int maxLength, int tabs) throws IOException {
        AnsiBufferedReader reader = new AnsiBufferedReader(is, 0, Integer.MAX_VALUE, maxLength);
        reader.setTabs(tabs);
        return reader;
    }

    public static class AnsiBufferedReader
    implements Closeable {
        private final BufferedReader reader;
        private final int begin;
        private final int end;
        private final int maxLength;
        private final AttributedStringBuilder builder;
        private final List<String> lines;

        public AnsiBufferedReader(InputStream in, int begin, int end, int maxLength) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.begin = begin;
            this.end = end;
            this.maxLength = maxLength;
            this.builder = new AttributedStringBuilder();
            this.lines = new ArrayList<String>();
        }

        public String readLine() throws IOException {
            if (this.lines.isEmpty()) {
                String line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                if (line.isEmpty()) {
                    this.lines.add("");
                } else {
                    this.builder.setLength(0);
                    this.builder.appendAnsi(line);
                    if (this.builder.length() > 0) {
                        this.builder.style(this.builder.styleAt(this.builder.length() - 1));
                    }
                    AttributedString str = this.builder.columnSubSequence(this.begin, this.end);
                    str.columnSplitLength(this.maxLength).stream().map(AttributedCharSequence::toAnsi).forEach(this.lines::add);
                }
            }
            return this.lines.remove(0);
        }

        @Override
        public void close() throws IOException {
        }

        public void setTabs(int tabs) {
            this.builder.tabs(tabs);
        }
    }
}

