/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.springframework.jms.connection.CachedMessageConsumer;
import org.springframework.jms.connection.CachedMessageProducer;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class CachingConnectionFactory
extends SingleConnectionFactory {
    private static final Method createSharedConsumerMethod = ClassUtils.getMethodIfAvailable(Session.class, (String)"createSharedConsumer", (Class[])new Class[]{Topic.class, String.class, String.class});
    private static final Method createSharedDurableConsumerMethod = ClassUtils.getMethodIfAvailable(Session.class, (String)"createSharedDurableConsumer", (Class[])new Class[]{Topic.class, String.class, String.class});
    private int sessionCacheSize = 1;
    private boolean cacheProducers = true;
    private boolean cacheConsumers = true;
    private volatile boolean active = true;
    private final Map<Integer, LinkedList<Session>> cachedSessions = new HashMap<Integer, LinkedList<Session>>();

    public CachingConnectionFactory() {
        this.setReconnectOnException(true);
    }

    public CachingConnectionFactory(ConnectionFactory targetConnectionFactory) {
        super(targetConnectionFactory);
        this.setReconnectOnException(true);
    }

    public void setSessionCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Session cache size must be 1 or higher");
        this.sessionCacheSize = sessionCacheSize;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setCacheProducers(boolean cacheProducers) {
        this.cacheProducers = cacheProducers;
    }

    public boolean isCacheProducers() {
        return this.cacheProducers;
    }

    public void setCacheConsumers(boolean cacheConsumers) {
        this.cacheConsumers = cacheConsumers;
    }

    public boolean isCacheConsumers() {
        return this.cacheConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetConnection() {
        this.active = false;
        Map<Integer, LinkedList<Session>> map = this.cachedSessions;
        synchronized (map) {
            Iterator<LinkedList<Session>> iterator = this.cachedSessions.values().iterator();
            while (iterator.hasNext()) {
                LinkedList<Session> sessionList;
                LinkedList<Session> linkedList = sessionList = iterator.next();
                synchronized (linkedList) {
                    for (Session session : sessionList) {
                        try {
                            session.close();
                        }
                        catch (Throwable ex) {
                            this.logger.trace((Object)"Could not close cached JMS Session", ex);
                        }
                    }
                }
            }
            this.cachedSessions.clear();
        }
        this.active = true;
        super.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Session getSession(Connection con, Integer mode) throws JMSException {
        LinkedList<Object> sessionList;
        Map<Integer, LinkedList<Session>> map = this.cachedSessions;
        synchronized (map) {
            sessionList = this.cachedSessions.get(mode);
            if (sessionList == null) {
                sessionList = new LinkedList();
                this.cachedSessions.put(mode, sessionList);
            }
        }
        Session session = null;
        LinkedList<Object> linkedList = sessionList;
        synchronized (linkedList) {
            if (!sessionList.isEmpty()) {
                session = (Session)sessionList.removeFirst();
            }
        }
        if (session != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found cached JMS Session for mode " + mode + ": " + (session instanceof SessionProxy ? ((SessionProxy)session).getTargetSession() : session)));
            }
        } else {
            Session targetSession = this.createSession(con, mode);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering cached JMS Session for mode " + mode + ": " + targetSession));
            }
            session = this.getCachedSessionProxy(targetSession, sessionList);
        }
        return session;
    }

    protected Session getCachedSessionProxy(Session target, LinkedList<Session> sessionList) {
        ArrayList<Class<TopicSession>> classes = new ArrayList<Class<TopicSession>>(3);
        classes.add(SessionProxy.class);
        if (target instanceof QueueSession) {
            classes.add(QueueSession.class);
        }
        if (target instanceof TopicSession) {
            classes.add(TopicSession.class);
        }
        return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CachedSessionInvocationHandler(target, sessionList));
    }

    private static class ConsumerCacheKey
    extends DestinationCacheKey {
        private final String selector;
        private final Boolean noLocal;
        private final String subscription;
        private final boolean durable;

        public ConsumerCacheKey(Destination destination, String selector, Boolean noLocal, String subscription, boolean durable) {
            super(destination);
            this.selector = selector;
            this.noLocal = noLocal;
            this.subscription = subscription;
            this.durable = durable;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            ConsumerCacheKey otherKey = (ConsumerCacheKey)other;
            return this.destinationEquals(otherKey) && ObjectUtils.nullSafeEquals((Object)this.selector, (Object)otherKey.selector) && ObjectUtils.nullSafeEquals((Object)this.noLocal, (Object)otherKey.noLocal) && ObjectUtils.nullSafeEquals((Object)this.subscription, (Object)otherKey.subscription) && this.durable == otherKey.durable;
        }
    }

    private static class DestinationCacheKey {
        private final Destination destination;
        private String destinationString;

        public DestinationCacheKey(Destination destination) {
            Assert.notNull((Object)destination, (String)"Destination must not be null");
            this.destination = destination;
        }

        private String getDestinationString() {
            if (this.destinationString == null) {
                this.destinationString = this.destination.toString();
            }
            return this.destinationString;
        }

        protected boolean destinationEquals(DestinationCacheKey otherKey) {
            return this.destination.getClass().equals(otherKey.destination.getClass()) && (this.destination.equals(otherKey.destination) || this.getDestinationString().equals(otherKey.getDestinationString()));
        }

        public boolean equals(Object other) {
            return other == this || this.destinationEquals((DestinationCacheKey)other);
        }

        public int hashCode() {
            return this.destination.getClass().hashCode();
        }
    }

    private class CachedSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final LinkedList<Session> sessionList;
        private final Map<DestinationCacheKey, MessageProducer> cachedProducers = new HashMap<DestinationCacheKey, MessageProducer>();
        private final Map<ConsumerCacheKey, MessageConsumer> cachedConsumers = new HashMap<ConsumerCacheKey, MessageConsumer>();
        private boolean transactionOpen = false;

        public CachedSessionInvocationHandler(Session target, LinkedList<Session> sessionList) {
            this.target = target;
            this.sessionList = sessionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return "Cached JMS Session: " + this.target;
            }
            if (methodName.equals("close")) {
                if (CachingConnectionFactory.this.active) {
                    LinkedList<Session> linkedList = this.sessionList;
                    synchronized (linkedList) {
                        if (this.sessionList.size() < CachingConnectionFactory.this.getSessionCacheSize()) {
                            try {
                                this.logicalClose((Session)proxy);
                                return null;
                            }
                            catch (JMSException ex) {
                                CachingConnectionFactory.this.logger.trace((Object)"Logical close of cached JMS Session failed - discarding it", (Throwable)ex);
                            }
                        }
                    }
                }
                this.physicalClose();
                return null;
            }
            if (methodName.equals("getTargetSession")) {
                return this.target;
            }
            if (methodName.equals("commit") || methodName.equals("rollback")) {
                this.transactionOpen = false;
            } else if (methodName.startsWith("create")) {
                this.transactionOpen = true;
                if (CachingConnectionFactory.this.isCacheProducers() && (methodName.equals("createProducer") || methodName.equals("createSender") || methodName.equals("createPublisher"))) {
                    return this.getCachedProducer((Destination)args[0]);
                }
                if (CachingConnectionFactory.this.isCacheConsumers()) {
                    Destination dest;
                    if (methodName.equals("createConsumer") || methodName.equals("createReceiver") || methodName.equals("createSubscriber")) {
                        dest = (Destination)args[0];
                        if (dest != null && !(dest instanceof TemporaryQueue) && !(dest instanceof TemporaryTopic)) {
                            return this.getCachedConsumer(dest, args.length > 1 ? (String)args[1] : null, args.length > 2 && (Boolean)args[2] != false, null, false);
                        }
                    } else if (methodName.equals("createDurableConsumer") || methodName.equals("createDurableSubscriber")) {
                        dest = (Destination)args[0];
                        if (dest != null) {
                            return this.getCachedConsumer(dest, args.length > 2 ? (String)args[2] : null, args.length > 3 && (Boolean)args[3] != false, (String)args[1], true);
                        }
                    } else if (methodName.equals("createSharedConsumer")) {
                        dest = (Destination)args[0];
                        if (dest != null) {
                            return this.getCachedConsumer(dest, args.length > 2 ? (String)args[2] : null, null, (String)args[1], false);
                        }
                    } else if (methodName.equals("createSharedDurableConsumer") && (dest = (Destination)args[0]) != null) {
                        return this.getCachedConsumer(dest, args.length > 2 ? (String)args[2] : null, null, (String)args[1], true);
                    }
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private MessageProducer getCachedProducer(Destination dest) throws JMSException {
            DestinationCacheKey cacheKey = dest != null ? new DestinationCacheKey(dest) : null;
            MessageProducer producer = this.cachedProducers.get(cacheKey);
            if (producer != null) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Found cached JMS MessageProducer for destination [" + dest + "]: " + producer));
                }
            } else {
                producer = this.target.createProducer(dest);
                if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                    CachingConnectionFactory.this.logger.debug((Object)("Registering cached JMS MessageProducer for destination [" + dest + "]: " + producer));
                }
                this.cachedProducers.put(cacheKey, producer);
            }
            return new CachedMessageProducer(producer).getProxyIfNecessary();
        }

        private MessageConsumer getCachedConsumer(Destination dest, String selector, Boolean noLocal, String subscription, boolean durable) throws JMSException {
            ConsumerCacheKey cacheKey = new ConsumerCacheKey(dest, selector, noLocal, subscription, durable);
            MessageConsumer consumer = this.cachedConsumers.get(cacheKey);
            if (consumer != null) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Found cached JMS MessageConsumer for destination [" + dest + "]: " + consumer));
                }
            } else {
                if (dest instanceof Topic) {
                    if (noLocal == null) {
                        Method method = durable ? createSharedDurableConsumerMethod : createSharedConsumerMethod;
                        try {
                            consumer = (MessageConsumer)method.invoke((Object)this.target, dest, subscription, selector);
                        }
                        catch (InvocationTargetException ex) {
                            if (ex.getTargetException() instanceof JMSException) {
                                throw (JMSException)ex.getTargetException();
                            }
                            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
                        }
                        catch (IllegalAccessException ex) {
                            throw new IllegalStateException("Could not access JMS 2.0 API method: " + ex.getMessage());
                        }
                    } else {
                        consumer = durable ? this.target.createDurableSubscriber((Topic)dest, subscription, selector, noLocal.booleanValue()) : this.target.createConsumer(dest, selector, noLocal.booleanValue());
                    }
                } else {
                    consumer = this.target.createConsumer(dest, selector);
                }
                if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                    CachingConnectionFactory.this.logger.debug((Object)("Registering cached JMS MessageConsumer for destination [" + dest + "]: " + consumer));
                }
                this.cachedConsumers.put(cacheKey, consumer);
            }
            return new CachedMessageConsumer(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logicalClose(Session proxy) throws JMSException {
            if (this.transactionOpen && this.target.getTransacted()) {
                this.transactionOpen = false;
                this.target.rollback();
            }
            Iterator<Map.Entry<ConsumerCacheKey, MessageConsumer>> it = this.cachedConsumers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ConsumerCacheKey, MessageConsumer> entry = it.next();
                if (entry.getKey().subscription == null) continue;
                entry.getValue().close();
                it.remove();
            }
            boolean returned = false;
            LinkedList<Session> linkedList = this.sessionList;
            synchronized (linkedList) {
                if (!this.sessionList.contains(proxy)) {
                    this.sessionList.addLast(proxy);
                    returned = true;
                }
            }
            if (returned && CachingConnectionFactory.this.logger.isTraceEnabled()) {
                CachingConnectionFactory.this.logger.trace((Object)("Returned cached Session: " + this.target));
            }
        }

        private void physicalClose() throws JMSException {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Session: " + this.target));
            }
            try {
                for (MessageProducer producer : this.cachedProducers.values()) {
                    producer.close();
                }
                for (MessageConsumer consumer : this.cachedConsumers.values()) {
                    consumer.close();
                }
            }
            finally {
                this.cachedProducers.clear();
                this.cachedConsumers.clear();
                this.target.close();
            }
        }
    }
}

