/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PropertiesEditorSupport {
    private PropertiesEditorSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Hashtable convertProperties(HttpServletRequest request) {
        Hashtable<String, Object> properties;
        String[] keys = request.getParameterValues("key");
        String[] vals = request.getParameterValues("val");
        String[] types = request.getParameterValues("type");
        Hashtable<String, Object> hashtable = properties = new Hashtable<String, Object>();
        synchronized (hashtable) {
            for (int i = 0; keys != null && i < keys.length; ++i) {
                properties.put(keys[i], PropertiesEditorSupport.convert(vals[i], types[i]));
            }
        }
        return properties;
    }

    private static final Object convert(String value, String type) {
        if ("byte".equals(type)) {
            return Byte.valueOf(value);
        }
        if ("int".equals(type)) {
            return Integer.valueOf(value);
        }
        if ("long".equals(type)) {
            return Long.valueOf(value);
        }
        if ("float".equals(type)) {
            return Float.valueOf(value);
        }
        if ("double".equals(type)) {
            return Double.valueOf(value);
        }
        if ("string".equals(type)) {
            return value.toString();
        }
        if ("char".equals(type)) {
            return new Character(value.toString().charAt(0));
        }
        if ("byte array".equals(type)) {
            return PropertiesEditorSupport.decodeHex(value.toString());
        }
        throw new IllegalArgumentException("Unsupported type!");
    }

    private static final byte[] decodeHex(String data) {
        StringTokenizer tok = new StringTokenizer(data, "[]{},;: \t");
        byte[] bs = new byte[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            bs[i++] = Integer.decode(next).byteValue();
        }
        return bs;
    }
}

