/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.management.internal;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.system.FrameworkType;
import org.apache.karaf.system.SystemService;
import org.apache.karaf.system.management.SystemMBean;
import org.osgi.framework.BundleContext;

public class SystemMBeanImpl
extends StandardMBean
implements SystemMBean {
    private SystemService systemService;
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public SystemMBeanImpl() throws NotCompliantMBeanException {
        super(SystemMBean.class);
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    @Override
    public void halt() throws MBeanException {
        try {
            this.systemService.halt();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void halt(String time) throws MBeanException {
        try {
            this.systemService.halt(time);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void reboot() throws MBeanException {
        try {
            this.systemService.reboot();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void reboot(String time) throws MBeanException {
        try {
            this.systemService.reboot(time, SystemService.Swipe.NONE);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void rebootCleanCache(String time) throws MBeanException {
        try {
            this.systemService.reboot(time, SystemService.Swipe.CACHE);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void rebootCleanAll(String time) throws MBeanException {
        try {
            this.systemService.reboot(time, SystemService.Swipe.ALL);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void setStartLevel(int startLevel) throws MBeanException {
        try {
            this.systemService.setStartLevel(startLevel);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public int getStartLevel() throws MBeanException {
        try {
            return this.systemService.getStartLevel();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public String getFramework() {
        return this.systemService.getFramework().toString();
    }

    @Override
    public void setFramework(String framework) {
        this.systemService.setFramework(FrameworkType.valueOf(framework.toLowerCase()));
    }

    @Override
    public void setFrameworkDebug(boolean debug) {
        this.systemService.setFrameworkDebug(debug);
    }

    @Override
    public String getName() {
        return this.systemService.getName();
    }

    @Override
    public void setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Instance name can't be null or empty");
        }
        this.systemService.setName(name);
    }

    @Override
    public String getVersion() {
        return this.systemService.getVersion();
    }

    @Override
    public Map<String, String> getProperties(boolean unset, boolean dumpToFile) throws MBeanException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = (Properties)System.getProperties().clone();
            String def = null;
            if (unset) {
                def = "unset";
            }
            this.setProperty(props, "org.osgi.framework.startlevel.beginning", def);
            this.setProperty(props, "org.osgi.framework.bootdelegation", def);
            this.setProperty(props, "org.osgi.framework.bundle.parent", def);
            this.setProperty(props, "app", def);
            this.setProperty(props, "boot", def);
            this.setProperty(props, "ext", def);
            this.setProperty(props, "framework", def);
            this.setProperty(props, "org.osgi.framework.command.execpermission", def);
            this.setProperty(props, "org.osgi.framework.executionenvironment", def);
            this.setProperty(props, "org.osgi.framework.language", def);
            this.setProperty(props, "org.osgi.framework.library.extensions", def);
            this.setProperty(props, "org.osgi.framework.os.name", def);
            this.setProperty(props, "org.osgi.framework.os.version", def);
            this.setProperty(props, "org.osgi.framework.processor", def);
            this.setProperty(props, "org.osgi.framework.security", def);
            this.setProperty(props, "osgi", def);
            this.setProperty(props, "org.osgi.framework.storage", def);
            this.setProperty(props, "onFirstInit", def);
            this.setProperty(props, "org.osgi.framework.system.packages", def);
            this.setProperty(props, "org.osgi.framework.system.packages.extra", def);
            this.setProperty(props, "org.osgi.framework.vendor", def);
            this.setProperty(props, "org.osgi.framework.version", def);
            this.setProperty(props, "org.osgi.framework.windowsystem", def);
            this.setProperty(props, "org.osgi.supports.bootclasspath.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.fragment", def);
            this.setProperty(props, "org.osgi.supports.framework.requirebundle", def);
            if (dumpToFile) {
                PrintStream ps = new PrintStream(new File(this.bundleContext.getProperty("karaf.data"), "dump-properties-" + System.currentTimeMillis() + ".properties"));
                ps.println("#Dump of the System and OSGi properties");
                ps.println("#Dump executed at " + new SimpleDateFormat().format(new Date()));
                this.printOrderedProperties(props, ps);
                ps.flush();
                ps.close();
            } else {
                this.printOrderedProperties(props, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    private void printOrderedProperties(Properties props, PrintStream out) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            out.println(key + "=" + props.getProperty(key));
        }
    }

    private void printOrderedProperties(Properties props, Map<String, String> result) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            result.put(key, props.getProperty(key));
        }
    }

    private void setProperty(Properties props, String key, String def) {
        String val = this.bundleContext.getProperty(key);
        if (val == null && def != null) {
            props.setProperty(key, def);
        } else if (val != null) {
            props.setProperty(key, val);
        }
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value, boolean persistent) {
        this.systemService.setSystemProperty(key, value, persistent);
    }
}

