/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.kex.ECDH;

public abstract class AbstractDH {
    protected BigInteger K;
    private byte[] K_array;

    protected AbstractDH() {
    }

    public static AbstractDH getInstance(String algo) throws Exception {
        if (algo.startsWith("ecdh-sha2-")) {
            return new ECDH();
        }
        return new DH();
    }

    public abstract void setF(byte[] var1);

    public abstract byte[] getE() throws Exception;

    protected abstract byte[] calculateK() throws Exception;

    public byte[] getK() throws Exception {
        if (this.K == null) {
            this.K_array = this.calculateK();
            this.K = new BigInteger(this.K_array);
        }
        return this.K_array;
    }

    public abstract Digest getHash() throws Exception;

    protected static byte[] stripLeadingZeroes(byte[] x) {
        int i;
        for (i = 0; i < x.length - 1 && x[i] == 0; ++i) {
        }
        byte[] ret = new byte[x.length - i];
        System.arraycopy(x, i, ret, 0, ret.length);
        return ret;
    }
}

