/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import shaded.org.apache.http.client.HttpRequestRetryHandler;
import shaded.org.apache.http.config.ConnectionConfig;
import shaded.org.apache.http.config.Registry;
import shaded.org.apache.http.config.RegistryBuilder;
import shaded.org.apache.http.config.SocketConfig;
import shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.org.apache.http.conn.ssl.SSLContextBuilder;
import shaded.org.apache.http.conn.ssl.SSLInitializationException;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import shaded.org.apache.http.impl.client.HttpClientBuilder;
import shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import shaded.org.apache.maven.wagon.providers.http.RelaxedTrustStrategy;
import shaded.org.ops4j.util.property.PropertyResolver;

public class HttpClients {
    public static CloseableHttpClient createClient(PropertyResolver resolver, String pid) {
        return HttpClientBuilder.create().useSystemProperties().disableConnectionState().setConnectionManager(HttpClients.createConnManager(resolver, pid)).setRetryHandler(HttpClients.createRetryHandler(resolver, pid)).build();
    }

    private static PoolingHttpClientConnectionManager createConnManager(PropertyResolver resolver, String pid) {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        String[] cipherSuites;
        boolean SSL_INSECURE = HttpClients.getBoolean(resolver, "maven.wagon.http.ssl.insecure", !HttpClients.getBoolean(resolver, pid + "certificateCheck", false));
        boolean IGNORE_SSL_VALIDITY_DATES = HttpClients.getBoolean(resolver, "maven.wagon.http.ssl.ignore.validity.dates", false);
        boolean SSL_ALLOW_ALL = HttpClients.getBoolean(resolver, "maven.wagon.http.ssl.allowall", !HttpClients.getBoolean(resolver, pid + "certificateCheck", false));
        boolean PERSISTENT_POOL = HttpClients.getBoolean(resolver, "maven.wagon.http.pool", true);
        int MAX_CONN_PER_ROUTE = HttpClients.getInteger(resolver, "maven.wagon.httpconnectionManager.maxPerRoute", 20);
        int MAX_CONN_TOTAL = HttpClients.getInteger(resolver, "maven.wagon.httpconnectionManager.maxTotal", 40);
        String sslProtocolsStr = HttpClients.getProperty(resolver, "https.protocols", null);
        String cipherSuitesStr = HttpClients.getProperty(resolver, "https.cipherSuites", null);
        String[] sslProtocols = sslProtocolsStr != null ? sslProtocolsStr.split(" *, *") : null;
        String[] stringArray = cipherSuites = cipherSuitesStr != null ? cipherSuitesStr.split(" *, *") : null;
        if (SSL_INSECURE) {
            try {
                SSLContext sslContext = new SSLContextBuilder().useSSL().loadTrustMaterial(null, new RelaxedTrustStrategy(IGNORE_SSL_VALIDITY_DATES)).build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, sslProtocols, cipherSuites, SSL_ALLOW_ALL ? SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new SSLInitializationException(ex.getMessage(), ex);
            }
        } else {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), sslProtocols, cipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)sslConnectionSocketFactory)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        if (PERSISTENT_POOL) {
            connManager.setDefaultMaxPerRoute(MAX_CONN_PER_ROUTE);
            connManager.setMaxTotal(MAX_CONN_TOTAL);
        } else {
            connManager.setMaxTotal(1);
        }
        boolean soKeepAlive = HttpClients.getBoolean(resolver, pid + "socket.keepAlive", false);
        int soLinger = HttpClients.getInteger(resolver, pid + "socket.linger", -1);
        boolean soReuseAddress = HttpClients.getBoolean(resolver, pid + "socket.reuseAddress", false);
        boolean soTcpNoDelay = HttpClients.getBoolean(resolver, pid + "socket.tcpNoDelay", true);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(soKeepAlive).setSoLinger(soLinger).setSoReuseAddress(soReuseAddress).setTcpNoDelay(soTcpNoDelay).setSoTimeout(0).build();
        connManager.setDefaultSocketConfig(socketConfig);
        int bufferSize = HttpClients.getInteger(resolver, pid + "connection.bufferSize", 8192);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(bufferSize).setFragmentSizeHint(bufferSize).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        return connManager;
    }

    private static HttpRequestRetryHandler createRetryHandler(PropertyResolver resolver, String pid) {
        int retryCount = HttpClients.getInteger(resolver, pid + "connection.retryCount", 3);
        return new DefaultHttpRequestRetryHandler(retryCount, false);
    }

    private static int getInteger(PropertyResolver resolver, String key, int def) {
        return Integer.parseInt(HttpClients.getProperty(resolver, key, Integer.toString(def)));
    }

    private static boolean getBoolean(PropertyResolver resolver, String key, boolean def) {
        return Boolean.parseBoolean(HttpClients.getProperty(resolver, key, Boolean.toString(def)));
    }

    private static String getProperty(PropertyResolver resolver, String key, String def) {
        String val = resolver != null ? resolver.get(key) : System.getProperty(key);
        return val == null ? def : val;
    }
}

