/*
 * Decompiled with CFR 0.152.
 */
package org.jledit;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jledit.ContentManager;
import org.jledit.utils.Files;
import org.jledit.utils.internal.Charsets;

public class FileContentManager
implements ContentManager {
    @Override
    public String load(String location) throws IOException {
        File file = new File(location);
        return Files.toString(file, this.detectCharset(location));
    }

    @Override
    public boolean save(String content, Charset charset, String location) {
        File file = new File(location);
        try {
            Files.writeToFile(file, content, charset);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean save(String content, String location) {
        return this.save(content, Charsets.UTF_8, location);
    }

    @Override
    public Charset detectCharset(String location) {
        return Charsets.detect(new File(location));
    }
}

