/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReader;
import org.springframework.util.ClassUtils;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public MetadataReader getMetadataReader(String className) throws IOException {
        int lastDotIndex;
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(className) + ".class";
        Resource resource = this.resourceLoader.getResource(resourcePath);
        if (!resource.exists() && (lastDotIndex = className.lastIndexOf(46)) != -1) {
            String innerClassName = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
            String innerClassResourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(innerClassName) + ".class";
            Resource innerClassResource = this.resourceLoader.getResource(innerClassResourcePath);
            if (innerClassResource.exists()) {
                resource = innerClassResource;
            }
        }
        return this.getMetadataReader(resource);
    }

    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        return new SimpleMetadataReader(resource, this.resourceLoader.getClassLoader());
    }
}

