/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.mina.MinaService;
import org.apache.sshd.common.io.mina.MinaSupport;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;

public class MinaSession
extends CloseableUtils.AbstractInnerCloseable
implements IoSession {
    private final MinaService service;
    private final org.apache.mina.core.session.IoSession session;

    public MinaSession(MinaService service, org.apache.mina.core.session.IoSession session) {
        this.service = service;
        this.session = session;
    }

    public org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public long getId() {
        return this.session.getId();
    }

    public WriteFuture write(byte[] data, int offset, int len) {
        IoBuffer buffer = IoBuffer.wrap((byte[])data, (int)offset, (int)len);
        return this.session.write((Object)buffer);
    }

    protected Closeable getInnerCloseable() {
        return new Closeable(){

            public boolean isClosing() {
                return MinaSession.this.session.isClosing();
            }

            public boolean isClosed() {
                return !MinaSession.this.session.isConnected();
            }

            public CloseFuture close(boolean immediately) {
                final DefaultCloseFuture future = new DefaultCloseFuture(MinaSession.this.lock);
                MinaSession.this.session.close(false).addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                    public void operationComplete(IoFuture f) {
                        future.setValue(true);
                    }
                });
                return future;
            }
        };
    }

    public IoWriteFuture write(Buffer buffer) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Future
        extends DefaultSshFuture<IoWriteFuture>
        implements IoWriteFuture {
            Future(Object lock) {
                super(lock);
            }

            @Override
            public void verify() throws SshException {
                try {
                    this.await();
                }
                catch (InterruptedException e) {
                    throw new SshException("Interrupted", (Throwable)e);
                }
                if (!this.isWritten()) {
                    throw new SshException("Write failed", this.getException());
                }
            }

            @Override
            public boolean isWritten() {
                return this.getValue() instanceof Boolean;
            }

            public void setWritten() {
                this.setValue(Boolean.TRUE);
            }

            @Override
            public Throwable getException() {
                Object v = this.getValue();
                return v instanceof Throwable ? (Throwable)v : null;
            }

            public void setException(Throwable exception) {
                if (exception == null) {
                    throw new IllegalArgumentException("exception");
                }
                this.setValue(exception);
            }
        }
        final Future future = new Future(null);
        this.session.write((Object)MinaSupport.asIoBuffer(buffer)).addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){
            {
            }

            public void operationComplete(WriteFuture cf) {
                if (cf.getException() != null) {
                    future.setException(cf.getException());
                } else {
                    future.setWritten();
                }
            }
        });
        return future;
    }

    public IoService getService() {
        return this.service;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.session.getLocalAddress() + ", remote=" + this.session.getRemoteAddress() + "]";
    }
}

