/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlTransient;

public class Exception
extends Throwable {
    private static final long serialVersionUID = -3387516993124229948L;
    private transient Reference<Class<?>>[] classContext = null;

    public Exception() {
        this.initClassContext();
    }

    public Exception(String detailMessage) {
        super(detailMessage);
        this.initClassContext();
    }

    public Exception(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.initClassContext();
    }

    public Exception(Throwable throwable) {
        super(throwable);
        this.initClassContext();
    }

    protected Exception(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        try {
            Field field = null;
            if (writableStackTrace) {
                this.fillInStackTrace();
            } else {
                field = Throwable.class.getDeclaredField("stackTrace");
                field.setAccessible(true);
                field.set(this, null);
            }
            field = Throwable.class.getDeclaredField("detailMessage");
            field.setAccessible(true);
            field.set(this, message);
            field = Throwable.class.getDeclaredField("cause");
            field.setAccessible(true);
            field.set(this, cause);
            if (!enableSuppression) {
                field = Throwable.class.getDeclaredField("suppressedExceptions");
                field.setAccessible(true);
                field.set(this, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initClassContext();
    }

    @XmlTransient
    @Deprecated
    public Class[] getClassContext() {
        Class[] context = null;
        if (this.classContext != null) {
            context = new Class[this.classContext.length];
            for (int i = 0; i < this.classContext.length; ++i) {
                Class<?> c = this.classContext[i].get();
                context[i] = c == null ? Object.class : c;
            }
        }
        return context;
    }

    private void initClassContext() {
        Class[] context = SecurityManagerEx.getInstance().getThrowableContext(this);
        if (context != null) {
            this.classContext = new Reference[context.length];
            for (int i = 0; i < context.length; ++i) {
                this.classContext[i] = new WeakReference<Class>(context[i]);
            }
        }
    }

    protected Class[] classContext() {
        Class[] context = new Class[this.classContext.length];
        for (int i = 0; i < this.classContext.length; ++i) {
            Class<?> c = this.classContext[i].get();
            context[i] = c == null ? Object.class : c;
        }
        return context;
    }

    private static class SecurityManagerEx
    extends SecurityManager {
        private static SecurityManagerEx sm;

        private SecurityManagerEx() {
        }

        public static SecurityManagerEx getInstance() {
            if (sm == null) {
                sm = new SecurityManagerEx();
            }
            return sm;
        }

        public Class[] getThrowableContext(Throwable t) {
            try {
                Class<?>[] context = this.getClassContext();
                int nb = 0;
                while (context[context.length - 1 - nb] != t.getClass()) {
                    ++nb;
                }
                Class[] nc = new Class[nb];
                System.arraycopy(context, context.length - nb, nc, 0, nb);
                return nc;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

