/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features.osgi;

import java.util.Hashtable;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.karaf.deployer.features.FeatureDeploymentListener;
import org.apache.karaf.deployer.features.FeatureURLHandler;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.url.URLStreamHandlerService;

@Services(requires={@RequireService(value=FeaturesService.class)})
public class Activator
extends BaseActivator {
    private FeatureDeploymentListener listener;

    @Override
    protected void doStart() throws Exception {
        FeaturesService service = this.getTrackedService(FeaturesService.class);
        if (service == null) {
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("url.handler.protocol", "feature");
        FeatureURLHandler handler = new FeatureURLHandler();
        this.register(URLStreamHandlerService.class, handler, props);
        this.listener = new FeatureDeploymentListener();
        this.listener.setFeaturesService(service);
        this.listener.setBundleContext(this.bundleContext);
        this.listener.init();
        this.register(new Class[]{ArtifactUrlTransformer.class, ArtifactListener.class}, this.listener);
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.listener != null) {
            this.listener.destroy();
            this.listener = null;
        }
    }
}

