/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngine;
import org.apache.karaf.jaas.modules.properties.PropertiesLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBackingEngineFactory
implements BackingEngineFactory {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PropertiesBackingEngineFactory.class);
    private static final String USER_FILE = "users";

    @Override
    public BackingEngine build(Map<String, ?> options) {
        PropertiesBackingEngine engine = null;
        String usersFile = (String)options.get(USER_FILE);
        File f = new File(usersFile);
        try {
            Properties users = new Properties(f);
            EncryptionSupport encryptionSupport = new EncryptionSupport(options);
            engine = new PropertiesBackingEngine(users, encryptionSupport);
        }
        catch (IOException ioe) {
            LOGGER.warn("Cannot open users file: {}", (Object)usersFile);
        }
        return engine;
    }

    @Override
    public String getModuleClass() {
        return PropertiesLoginModule.class.getName();
    }
}

