/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBeanFactoryBasedTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    private static final long serialVersionUID = -4721607536018568393L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String targetBeanName;
    private Class<?> targetClass;
    private BeanFactory beanFactory;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.targetBeanName == null) {
            throw new IllegalStateException("Property 'targetBeanName' is required");
        }
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        if (this.targetClass == null && this.beanFactory != null) {
            this.targetClass = this.beanFactory.getType(this.targetBeanName);
            if (this.targetClass == null) {
                Object beanInstance;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Getting bean with name '" + this.targetBeanName + "' in order to determine type"));
                }
                if ((beanInstance = this.beanFactory.getBean(this.targetBeanName)) != null) {
                    this.targetClass = beanInstance.getClass();
                }
            }
        }
        return this.targetClass;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public void releaseTarget(Object target) throws Exception {
    }

    protected void copyFrom(AbstractBeanFactoryBasedTargetSource other) {
        this.targetBeanName = other.targetBeanName;
        this.targetClass = other.targetClass;
        this.beanFactory = other.beanFactory;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractBeanFactoryBasedTargetSource otherTargetSource = (AbstractBeanFactoryBasedTargetSource)other;
        return ObjectUtils.nullSafeEquals((Object)this.beanFactory, (Object)otherTargetSource.beanFactory) && ObjectUtils.nullSafeEquals((Object)this.targetBeanName, (Object)otherTargetSource.targetBeanName);
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        hashCode = 13 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.beanFactory);
        hashCode = 13 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.targetBeanName);
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" for target bean '").append(this.targetBeanName).append("'");
        if (this.targetClass != null) {
            sb.append(" of type [").append(this.targetClass.getName()).append("]");
        }
        return sb.toString();
    }
}

