/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.action.command.ActionCommand;
import org.apache.karaf.shell.impl.console.commands.help.HelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.wikidoc.AnsiPrintingWikiVisitor;
import org.apache.karaf.shell.impl.console.commands.help.wikidoc.WikiParser;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ShellHelpProvider
implements HelpProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHelp(Session session, String path) {
        if (path.indexOf(124) > 0) {
            if (!path.startsWith("shell|")) return null;
            path = path.substring("shell|".length());
        }
        Set<Command> commands = this.getCommands(session, path);
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        HashSet<String> scopes = new HashSet<String>();
        for (Command command : commands) {
            if (command instanceof ActionCommand) {
                Class<? extends Action> action = ((ActionCommand)command).getActionClass();
                bundles.add(FrameworkUtil.getBundle(action));
            }
            scopes.add(command.getScope());
        }
        if (scopes.size() != 1) return null;
        if (bundles.size() != 1) return null;
        if (!path.equals(scopes.iterator().next())) return null;
        Bundle bundle = (Bundle)bundles.iterator().next();
        URL resource = bundle.getResource("OSGI-INF/shell-" + path + ".info");
        if (resource != null) {
            try (BufferedReader reader2222 = new BufferedReader(new InputStreamReader(resource.openStream()));){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                int maxSize = 80;
                Terminal terminal = session.getTerminal();
                if (terminal != null) {
                    maxSize = terminal.getWidth();
                }
                AnsiPrintingWikiVisitor visitor = new AnsiPrintingWikiVisitor(ps, maxSize);
                WikiParser parser = new WikiParser(visitor);
                parser.parse(reader2222);
                String string = baos.toString();
                return string;
            }
            catch (IOException reader2222) {
                // empty catch block
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printShellHelp(session, new PrintStream(baos), path);
        return baos.toString();
    }

    private Set<Command> getCommands(Session session, String path) {
        List<Command> commands = session.getRegistry().getCommands();
        String subshell = (String)session.get("SUBSHELL");
        String completionMode = (String)session.get("karaf.completionMode");
        HashSet<Command> matchingCommands = new HashSet<Command>();
        for (Command command : commands) {
            String name = command.getScope() + ":" + command.getName();
            if (command != null && !name.startsWith(path) || completionMode != null && completionMode.equalsIgnoreCase("subshell") && (subshell == null || subshell.trim().isEmpty()) && !name.startsWith("*") || completionMode != null && (completionMode.equalsIgnoreCase("subshell") || completionMode.equalsIgnoreCase("first")) && !name.startsWith(subshell)) continue;
            matchingCommands.add(command);
        }
        return matchingCommands;
    }

    protected void printShellHelp(Session session, PrintStream out, String path) {
        out.println(SimpleAnsi.INTENSITY_BOLD + "SUBSHELL" + SimpleAnsi.INTENSITY_NORMAL);
        out.println("\t" + SimpleAnsi.INTENSITY_BOLD + path + SimpleAnsi.INTENSITY_NORMAL);
        out.println();
        out.println(SimpleAnsi.INTENSITY_BOLD + "COMMANDS" + SimpleAnsi.INTENSITY_NORMAL);
        out.println("${command-list|" + path + "|indent}");
    }
}

