/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.shell.support.table.HAlign;

public class Col {
    private String header;
    int maxSize = -1;
    int size = 0;
    boolean wrap;
    boolean bold;
    boolean cyan;
    private HAlign align = HAlign.left;

    public Col(String header) {
        this.header = header;
    }

    public Col align(HAlign align) {
        this.align = align;
        return this;
    }

    public Col alignLeft() {
        this.align = HAlign.left;
        return this;
    }

    public Col alignRight() {
        this.align = HAlign.right;
        return this;
    }

    public Col alignCenter() {
        this.align = HAlign.center;
        return this;
    }

    public Col maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Col wrap() {
        return this.wrap(true);
    }

    public Col wrap(boolean wrap) {
        this.wrap = wrap;
        return this;
    }

    public Col bold() {
        return this.bold(true);
    }

    public Col bold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public Col cyan() {
        return this.cyan(true);
    }

    public Col cyan(boolean cyan) {
        this.cyan = cyan;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    protected void updateSize(int cellSize) {
        if (this.size <= cellSize) {
            this.size = this.getClippedSize(cellSize);
        }
    }

    private int getClippedSize(int cellSize) {
        return this.maxSize == -1 ? cellSize : Math.min(cellSize, this.maxSize);
    }

    String format(Object cellData) {
        String fullContent;
        if (cellData == null) {
            cellData = "";
        }
        if ((fullContent = String.format("%s", cellData)).length() == 0) {
            return "";
        }
        String finalContent = this.cut(fullContent, this.getClippedSize(fullContent.length()));
        this.updateSize(finalContent.length());
        return finalContent;
    }

    String getHeader() {
        return this.header;
    }

    String getContent(String content) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(Arrays.asList(content.split("\n")));
        if (this.wrap) {
            ArrayList<String> wrapped = new ArrayList<String>();
            for (String line : lines) {
                wrapped.addAll(this.wrap(line));
            }
            lines = wrapped;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            line = this.align.position(this.cut(line, this.size), this.size);
            if (this.bold) {
                line = SimpleAnsi.INTENSITY_BOLD + line + SimpleAnsi.INTENSITY_NORMAL;
            }
            if (this.cyan) {
                line = SimpleAnsi.COLOR_CYAN + line + SimpleAnsi.COLOR_DEFAULT;
            }
            sb.append(line);
        }
        return sb.toString();
    }

    protected String cut(String content, int size) {
        if (content.length() <= size) {
            return content;
        }
        return content.substring(0, Math.max(0, size - 1));
    }

    protected List<String> wrap(String str) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern wrap = Pattern.compile("(\\S\\S{" + this.size + ",}|.{1," + this.size + "})(\\s+|$)");
        int cur = 0;
        while (cur >= 0) {
            String s;
            int lst = str.indexOf(10, cur);
            String string = s = lst >= 0 ? str.substring(cur, lst) : str.substring(cur);
            if (s.length() == 0) {
                result.add(s);
            } else {
                Matcher m = wrap.matcher(s);
                while (m.find()) {
                    result.add(m.group());
                }
            }
            if (lst < 0) break;
            cur = lst + 1;
        }
        return result;
    }
}

