/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import javax.crypto.KeyAgreement;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.util.SecurityUtils;

public class ECDH
extends AbstractDH {
    private ECParameterSpec params;
    private ECPoint e;
    private byte[] e_array;
    private ECPoint f;
    private KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("EC");
    private KeyAgreement myKeyAgree = SecurityUtils.getKeyAgreement("ECDH");

    public byte[] getE() throws Exception {
        if (this.e == null) {
            this.myKpairGen.initialize(this.params);
            KeyPair myKpair = this.myKpairGen.generateKeyPair();
            this.myKeyAgree.init(myKpair.getPrivate());
            this.e = ((ECPublicKey)myKpair.getPublic()).getW();
            this.e_array = ECCurves.encodeECPoint(this.e, this.params.getCurve());
        }
        return this.e_array;
    }

    protected byte[] calculateK() throws Exception {
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory("EC");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(this.f, this.params);
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return ECDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setCurveParameters(ECParameterSpec params) {
        this.params = params;
    }

    public void setF(byte[] f) {
        this.f = ECCurves.decodeECPoint(f, this.params.getCurve());
    }

    public Digest getHash() throws Exception {
        return ECCurves.getDigestForParams(this.params);
    }
}

