/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Function;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="shell", name="while", description="Loop while the condition is true.")
@Service
public class WhileAction
implements Action {
    @Argument(name="condition", index=0, multiValued=false, required=true, description="The condition of the loop")
    Function condition;
    @Argument(name="function", index=1, multiValued=false, required=true, description="The function to execute")
    Function function;
    @Reference
    Session session;

    public Object execute() throws Exception {
        while (this.isTrue(this.condition.execute(this.session, null))) {
            this.function.execute(this.session, null);
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedException();
        }
        return null;
    }

    private boolean isTrue(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof String && ((String)result).equals("")) {
            return false;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue() != 0.0;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }
}

