/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.internal.MessageUtil;

public class CloseableDirectory
implements ICloseableDirectory {
    protected IDirectory delegate;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public CloseableDirectory(IDirectory delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        this.checkNotClosed();
        return this.delegate.getName();
    }

    @Override
    public boolean isDirectory() {
        this.checkNotClosed();
        return this.delegate.isDirectory();
    }

    @Override
    public boolean isFile() {
        this.checkNotClosed();
        return this.delegate.isFile();
    }

    @Override
    public long getLastModified() {
        this.checkNotClosed();
        return this.delegate.getLastModified();
    }

    @Override
    public IFile getFile(String name) {
        this.checkNotClosed();
        return this.delegate.getFile(name);
    }

    @Override
    public long getSize() {
        this.checkNotClosed();
        return this.delegate.getSize();
    }

    @Override
    public IDirectory convert() {
        this.checkNotClosed();
        return this.delegate.convert();
    }

    @Override
    public IDirectory convertNested() {
        this.checkNotClosed();
        return this.delegate.convertNested();
    }

    @Override
    public boolean isRoot() {
        this.checkNotClosed();
        return this.delegate.isRoot();
    }

    @Override
    public IDirectory getParent() {
        this.checkNotClosed();
        return this.delegate.getParent();
    }

    @Override
    public IDirectory getRoot() {
        this.checkNotClosed();
        return this.delegate.getRoot();
    }

    @Override
    public Iterator<IFile> iterator() {
        this.checkNotClosed();
        return this.delegate.iterator();
    }

    @Override
    public List<IFile> listFiles() {
        this.checkNotClosed();
        return this.delegate.listFiles();
    }

    @Override
    public List<IFile> listAllFiles() {
        this.checkNotClosed();
        return this.delegate.listAllFiles();
    }

    @Override
    public ICloseableDirectory toCloseable() {
        this.checkNotClosed();
        return this.delegate.toCloseable();
    }

    @Override
    public InputStream open() throws IOException, UnsupportedOperationException {
        this.checkNotClosed();
        return this.delegate.open();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        this.checkNotClosed();
        return this.delegate.toURL();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    protected void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(MessageUtil.getMessage("UTIL0018E", new Object[0]));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

