/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.aries.blueprint.compendium.cm.ManagedObject;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedObjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedObjectManager.class);
    private HashMap<String, ConfigurationWatcher> map = new HashMap();

    public synchronized void register(ManagedObject cm, Properties props) {
        String key = cm.getPersistentId();
        ConfigurationWatcher reg = this.map.get(key);
        if (reg == null) {
            reg = new ConfigurationWatcher();
            ServiceRegistration registration = cm.getBundle().getBundleContext().registerService(ManagedService.class.getName(), (Object)reg, (Dictionary)props);
            reg.setRegistration(registration);
            this.map.put(key, reg);
        }
        reg.add(cm);
    }

    public synchronized void unregister(ManagedObject cm) {
        String key = cm.getPersistentId();
        ConfigurationWatcher reg = this.map.get(key);
        if (reg != null) {
            reg.remove(cm);
            if (reg.isEmpty()) {
                this.map.remove(key);
                AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)reg.getRegistration());
            }
        }
    }

    private static class ConfigurationWatcher
    implements ManagedService {
        private ServiceRegistration registration;
        private List<ManagedObject> list = new CopyOnWriteArrayList<ManagedObject>();

        public void updated(final Dictionary props) throws ConfigurationException {
            new Thread(){

                @Override
                public void run() {
                    for (ManagedObject cm : ConfigurationWatcher.this.list) {
                        cm.updated(props);
                    }
                }
            }.start();
        }

        private void setRegistration(ServiceRegistration registration) {
            this.registration = registration;
        }

        private ServiceRegistration getRegistration() {
            return this.registration;
        }

        private void add(ManagedObject cm) {
            this.list.add(cm);
        }

        private void remove(ManagedObject cm) {
            this.list.remove(cm);
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

