/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.util.SecurityUtils;

public abstract class AbstractSignature
implements Signature {
    protected java.security.Signature signature;
    protected String algorithm;

    protected AbstractSignature(String algorithm) {
        this.algorithm = algorithm;
    }

    public void init(PublicKey pubkey, PrivateKey prvkey) throws Exception {
        this.signature = SecurityUtils.getSignature(this.algorithm);
        if (pubkey != null) {
            this.signature.initVerify(pubkey);
        }
        if (prvkey != null) {
            this.signature.initSign(prvkey);
        }
    }

    public void update(byte[] foo, int off, int len) throws Exception {
        this.signature.update(foo, off, len);
    }

    protected byte[] extractSig(byte[] sig) {
        if (sig[0] == 0 && sig[1] == 0 && sig[2] == 0) {
            int i = 0;
            int j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            i += j;
            j = sig[i++] << 24 & 0xFF000000 | sig[i++] << 16 & 0xFF0000 | sig[i++] << 8 & 0xFF00 | sig[i++] & 0xFF;
            byte[] tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        return sig;
    }
}

