/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String methodName, String beanName) {
        super(methodName);
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public boolean matches(Method method) {
        return method.getName().equals(this.getMethodName()) && method.getParameterTypes().length == 0;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LookupOverride && super.equals(other) && ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)((LookupOverride)other).beanName);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode((Object)this.beanName);
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'";
    }
}

