/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer.analyzers;

import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.Version;
import org.osgi.resource.Capability;

public class OSGiFrameworkAnalyzer
implements ResourceAnalyzer {
    private static final String SERVICE_FRAMEWORK_FACTORY = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";
    private static final String FRAMEWORK_PACKAGE = "org.osgi.framework";

    public void analyzeResource(Jar resource, ResourceBuilder rb) throws Exception {
        Resource fwkFactorySvc = resource.getResource(SERVICE_FRAMEWORK_FACTORY);
        if (fwkFactorySvc != null) {
            CapReqBuilder builder = new CapReqBuilder("osgi.contract").addAttribute("osgi.contract", "OSGiFramework");
            Version specVersion = null;
            StringBuilder uses = new StringBuilder();
            boolean firstPkg = true;
            for (Capability cap : rb.getCapabilities()) {
                if (!"osgi.wiring.package".equals(cap.getNamespace())) continue;
                if (!firstPkg) {
                    uses.append(',');
                }
                String pkgName = (String)cap.getAttributes().get("osgi.wiring.package");
                uses.append(pkgName);
                firstPkg = false;
                if (!FRAMEWORK_PACKAGE.equals(pkgName)) continue;
                Version frameworkPkgVersion = (Version)cap.getAttributes().get("version");
                specVersion = this.mapFrameworkPackageVersion(frameworkPkgVersion);
            }
            if (specVersion != null) {
                builder.addAttribute("version", specVersion);
            }
            builder.addDirective("uses", uses.toString());
            rb.addCapability(builder);
        }
    }

    private Version mapFrameworkPackageVersion(Version pv) {
        Version version;
        if (pv.getMajor() != 1) {
            return null;
        }
        switch (pv.getMinor()) {
            case 7: {
                version = new Version(5, 0, 0);
                break;
            }
            case 6: {
                version = new Version(4, 3, 0);
                break;
            }
            case 5: {
                version = new Version(4, 2, 0);
                break;
            }
            case 4: {
                version = new Version(4, 1, 0);
                break;
            }
            case 3: {
                version = new Version(4, 0, 0);
                break;
            }
            case 2: {
                version = new Version(3, 0, 0);
                break;
            }
            case 1: {
                version = new Version(2, 0, 0);
                break;
            }
            case 0: {
                version = new Version(1, 0, 0);
                break;
            }
            default: {
                version = null;
            }
        }
        return version;
    }
}

