/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command.completers;

import java.util.List;
import java.util.SortedSet;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

public abstract class FeatureCompleterSupport
implements Completer {
    @Reference
    protected FeaturesService featuresService;

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            for (Feature feature : this.featuresService.listFeatures()) {
                if (!this.acceptsFeature(feature)) continue;
                this.add(delegate.getStrings(), feature);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delegate.complete(session, commandLine, candidates);
    }

    protected void add(SortedSet<String> candidates, Feature feature) {
        candidates.add(feature.getName());
    }

    protected abstract boolean acceptsFeature(Feature var1);
}

