/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;

public class BundleInfoImpl
implements BundleInfo {
    private int startLevel;
    private String name;
    private String symbolicName;
    private String updateLocation;
    private String version;
    private String revisions;
    private long bundleId;
    private BundleState state;
    private boolean isFragment;
    private List<Bundle> fragments;
    private List<Bundle> fragmentHosts;
    private static Map<Integer, BundleState> bundleStateMap = new HashMap<Integer, BundleState>();

    public BundleInfoImpl(Bundle bundle, BundleState extState) {
        BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        this.startLevel = bsl.getStartLevel();
        this.name = (String)bundle.getHeaders().get("Bundle-Name");
        this.symbolicName = bundle.getSymbolicName();
        String locationFromHeader = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
        this.updateLocation = locationFromHeader != null ? locationFromHeader : bundle.getLocation();
        this.version = (String)bundle.getHeaders().get("Bundle-Version");
        this.revisions = this.populateRevisions(bundle);
        this.bundleId = bundle.getBundleId();
        this.state = extState != BundleState.Unknown ? extState : this.getBundleState(bundle);
        this.populateFragementInfos(bundle);
    }

    private void populateFragementInfos(Bundle bundle) {
        this.isFragment = bundle.getHeaders().get("Fragment-Host") != null;
        this.fragments = new ArrayList<Bundle>();
        this.fragmentHosts = new ArrayList<Bundle>();
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        if (revisions == null) {
            return;
        }
        for (BundleRevision revision : revisions.getRevisions()) {
            if (revision.getWiring() == null) continue;
            this.getFragments(revision);
            this.getFragmentHosts(revision);
        }
    }

    private String populateRevisions(Bundle bundle) {
        String ret = "";
        BundleRevisions revisions = (BundleRevisions)bundle.adapt(BundleRevisions.class);
        if (revisions == null) {
            return ret;
        }
        for (BundleRevision revision : revisions.getRevisions()) {
            ret = ret + "[" + revision + "]" + " ";
        }
        return ret;
    }

    private void getFragments(BundleRevision revision) {
        List wires = revision.getWiring().getProvidedWires("osgi.wiring.host");
        if (wires != null) {
            for (BundleWire w : wires) {
                Bundle b = w.getRequirerWiring().getBundle();
                this.fragments.add(b);
            }
        }
    }

    private void getFragmentHosts(BundleRevision revision) {
        List wires = revision.getWiring().getRequiredWires("osgi.wiring.host");
        if (wires != null) {
            for (BundleWire w : wires) {
                Bundle b = w.getProviderWiring().getBundle();
                if (b == null) continue;
                this.fragmentHosts.add(b);
            }
        }
    }

    private BundleState getBundleState(Bundle bundle) {
        BundleState state = bundleStateMap.get(bundle.getState());
        return state == null ? BundleState.Unknown : state;
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUpdateLocation() {
        return this.updateLocation;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public BundleState getState() {
        return this.state;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel;
    }

    @Override
    public boolean isFragment() {
        return this.isFragment;
    }

    @Override
    public List<Bundle> getFragments() {
        return this.fragments;
    }

    @Override
    public List<Bundle> getFragmentHosts() {
        return this.fragmentHosts;
    }

    @Override
    public String getRevisions() {
        return this.revisions;
    }

    static {
        bundleStateMap.put(32, BundleState.Active);
        bundleStateMap.put(2, BundleState.Installed);
        bundleStateMap.put(4, BundleState.Resolved);
        bundleStateMap.put(8, BundleState.Starting);
        bundleStateMap.put(16, BundleState.Stopping);
    }
}

