/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.indexer.analyzers;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.indexer.MimeType;
import aQute.bnd.indexer.ResourceAnalyzer;
import aQute.bnd.indexer.analyzers.EE;
import aQute.bnd.indexer.analyzers.Yield;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.VersionRange;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleAnalyzer
implements ResourceAnalyzer {
    private static final String SUFFIX_JAR = ".jar";

    @Override
    public void analyzeResource(Jar resource, ResourceBuilder rb) throws Exception {
        Manifest manifest = resource.getManifest();
        if (manifest == null) {
            return;
        }
        Domain domain = Domain.domain(manifest);
        MimeType mimeType = MimeType.Jar;
        if (resource.getBsn() != null) {
            mimeType = MimeType.Bundle;
            if (domain.getFragmentHost() != null) {
                mimeType = MimeType.Fragment;
            }
        }
    }

    private void doBundleIdentity(Domain domain, MimeType mimeType, List<? super Capability> caps) throws Exception {
        String type;
        switch (mimeType) {
            case Bundle: {
                type = "osgi.bundle";
                break;
            }
            case Fragment: {
                type = "osgi.fragment";
                break;
            }
            default: {
                type = "jarfile";
            }
        }
        Map.Entry<String, Attrs> bundleSymbolicName = domain.getBundleSymbolicName();
        String bsn = bundleSymbolicName.getKey();
        String s = bundleSymbolicName.getValue().get("singleton:");
        boolean singleton = ((Object)Boolean.TRUE).toString().equalsIgnoreCase(s);
        Version version = Version.parseVersion((String)domain.getBundleVersion());
        CapReqBuilder builder = new CapReqBuilder("osgi.identity").addAttribute("osgi.identity", bsn).addAttribute("type", type).addAttribute("version", version);
        if (singleton) {
            builder.addDirective("singleton", ((Object)Boolean.TRUE).toString());
        }
        caps.add((Capability)builder.buildCapability());
    }

    private void doPlainJarIdentity(Jar resource, List<? super Capability> caps) {
        String name = resource.getName();
        if (name.toLowerCase().endsWith(SUFFIX_JAR)) {
            name = name.substring(0, name.length() - SUFFIX_JAR.length());
        }
        Version version = null;
        int dashIndex = name.lastIndexOf(45);
        if (dashIndex > 0) {
            try {
                String versionStr = name.substring(dashIndex + 1);
                version = new Version(versionStr);
                name = name.substring(0, dashIndex);
            }
            catch (Exception e) {
                version = null;
            }
        }
        CapReqBuilder builder = new CapReqBuilder("osgi.identity").addAttribute("osgi.identity", name).addAttribute("type", "jarfile");
        if (version != null) {
            builder.addAttribute("version", version);
        }
        caps.add((Capability)builder.buildCapability());
    }

    private void doBundleAndHost(Domain domain, List<? super Capability> caps) throws Exception {
        CapReqBuilder bundleBuilder = new CapReqBuilder("osgi.wiring.bundle");
        CapReqBuilder hostBuilder = new CapReqBuilder("osgi.wiring.host");
        boolean allowFragments = true;
        if (domain.getFragmentHost() != null) {
            return;
        }
        Map.Entry<String, Attrs> bsn = domain.getBundleSymbolicName();
        Version version = Version.parseVersion((String)bsn.getValue().getVersion());
        bundleBuilder.addAttribute("osgi.wiring.bundle", bsn.getKey()).addAttribute("bundle-version", version);
        hostBuilder.addAttribute("osgi.wiring.host", bsn.getKey()).addAttribute("bundle-version", version);
        for (Map.Entry<String, String> entry : bsn.getValue().entrySet()) {
            String key = entry.getKey();
            if (key.endsWith(":")) {
                String directiveName = key.substring(0, key.length() - 1);
                if ("fragment-attachment".equalsIgnoreCase(directiveName)) {
                    if (!"never".equalsIgnoreCase(entry.getValue())) continue;
                    allowFragments = false;
                    continue;
                }
                if ("singleton".equalsIgnoreCase(directiveName)) continue;
                bundleBuilder.addDirective(directiveName, entry.getValue());
                continue;
            }
            bundleBuilder.addAttribute(key, entry.getValue());
        }
        caps.add((Capability)bundleBuilder.buildCapability());
        if (allowFragments) {
            caps.add((Capability)hostBuilder.buildCapability());
        }
    }

    private void doExports(Domain domain, List<? super Capability> caps) throws Exception {
        Parameters exports = domain.getExportPackage();
        for (Map.Entry<String, Attrs> entry : exports.entrySet()) {
            CapReqBuilder builder = new CapReqBuilder("osgi.wiring.package");
            String pkgName = Processor.removeDuplicateMarker(entry.getKey());
            builder.addAttribute("osgi.wiring.package", pkgName);
            String versionStr = entry.getValue().getVersion();
            Version version = Version.parseVersion((String)versionStr);
            builder.addAttribute("version", version);
            for (Map.Entry<String, String> attribEntry : entry.getValue().entrySet()) {
                String key = attribEntry.getKey();
                if ("specification-version".equalsIgnoreCase(key) || "version".equalsIgnoreCase(key)) continue;
                if (key.endsWith(":")) {
                    builder.addDirective(key.substring(0, key.length() - 1), attribEntry.getValue());
                    continue;
                }
                builder.addAttribute(key, attribEntry.getValue());
            }
            Map.Entry<String, Attrs> bsn = domain.getBundleSymbolicName();
            builder.addAttribute("bundle-symbolic-name", bsn.getKey());
            builder.addAttribute("bundle-version", Version.parseVersion((String)bsn.getValue().getVersion()));
            caps.add((Capability)builder.buildCapability());
        }
    }

    private void doImports(Domain domain, List<? super Requirement> reqs) throws Exception {
        Parameters imports = domain.getImportPackage();
        for (Map.Entry<String, Attrs> entry : imports.entrySet()) {
            StringBuilder filter = new StringBuilder();
            String pkgName = Processor.removeDuplicateMarker(entry.getKey());
            filter.append("(osgi.wiring.package=").append(pkgName).append(")");
            String versionStr = entry.getValue().get("version");
            if (versionStr != null) {
                VersionRange version = new VersionRange(versionStr);
                filter.insert(0, "(&");
                filter.append(version.toFilter());
                filter.append(")");
            }
            CapReqBuilder builder = new CapReqBuilder("osgi.wiring.package").addDirective("filter", filter.toString());
            this.copyAttribsAndDirectives(entry.getValue(), builder, "version", "specification-version");
            reqs.add((Requirement)builder.buildRequirement());
        }
    }

    private void copyAttribsAndDirectives(Map<String, String> input, CapReqBuilder output, String ... ignores) {
        HashSet<String> ignoreSet = new HashSet<String>(Arrays.asList(ignores));
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String key = entry.getKey();
            if (ignoreSet.contains(key)) continue;
            if (key.endsWith(":")) {
                String directive = key.substring(0, key.length() - 1);
                output.addDirective(directive, entry.getValue());
                continue;
            }
            output.addAttribute(key, entry.getValue());
        }
    }

    private void doRequireBundles(Domain domain, List<? super Requirement> reqs) throws Exception {
        Parameters requires = domain.getRequireBundle();
        for (Map.Entry<String, Attrs> entry : requires.entrySet()) {
            StringBuilder filter = new StringBuilder();
            String bsn = Processor.removeDuplicateMarker(entry.getKey());
            filter.append("(osgi.wiring.bundle=").append(bsn).append(")");
            String versionStr = entry.getValue().get("bundle-version");
            if (versionStr != null) {
                VersionRange version = new VersionRange(versionStr);
                filter.insert(0, "(&");
                filter.append(version.toFilter());
                filter.append(")");
            }
            CapReqBuilder builder = new CapReqBuilder("osgi.wiring.bundle").addDirective("filter", filter.toString());
            this.copyAttribsAndDirectives(entry.getValue(), builder, "bundle-version");
            reqs.add((Requirement)builder.buildRequirement());
        }
    }

    private void doFragment(Domain domain, List<? super Requirement> reqs) throws Exception {
        Map.Entry<String, Attrs> fragmentHost = domain.getFragmentHost();
        if (fragmentHost != null) {
            StringBuilder filter = new StringBuilder();
            String bsn = fragmentHost.getKey();
            filter.append("(&(osgi.wiring.host=").append(bsn).append(")");
            String versionStr = fragmentHost.getValue().get("bundle-version");
            VersionRange range = new VersionRange(versionStr);
            filter.append(range.toFilter());
            filter.append(")");
            CapReqBuilder builder = new CapReqBuilder("osgi.wiring.host").addDirective("filter", filter.toString());
            reqs.add((Requirement)builder.buildRequirement());
        }
    }

    private void doExportService(Domain domain, List<? super Capability> caps) throws Exception {
        Parameters exports = new Parameters(domain.get("Export-Service"));
        for (Map.Entry<String, Attrs> export : exports.entrySet()) {
            String service = Processor.removeDuplicateMarker(export.getKey());
            CapReqBuilder builder = new CapReqBuilder("osgi.service").addAttribute("objectClass", service);
            for (Map.Entry<String, String> attribEntry : export.getValue().entrySet()) {
                builder.addAttribute(attribEntry.getKey(), attribEntry.getValue());
            }
            builder.addDirective("effective", "active");
            caps.add((Capability)builder.buildCapability());
        }
    }

    private void doImportService(Domain domain, List<? super Requirement> reqs) throws Exception {
        Parameters imports = new Parameters(domain.get("Import-Service"));
        for (Map.Entry<String, Attrs> imp : imports.entrySet()) {
            String service = Processor.removeDuplicateMarker(imp.getKey());
            StringBuilder filter = new StringBuilder();
            filter.append('(').append("objectClass").append('=').append(service).append(')');
            CapReqBuilder builder = new CapReqBuilder("osgi.service").addDirective("filter", filter.toString()).addDirective("effective", "active");
            reqs.add((Requirement)builder.buildRequirement());
        }
    }

    private void doBREE(Domain domain, List<? super Requirement> reqs) throws Exception {
        Parameters brees = domain.getBundleRequiredExecutionEnvironment();
        if (!brees.isEmpty()) {
            String filter;
            if (brees.size() == 1) {
                String bree = brees.keySet().iterator().next();
                filter = EE.parseBREE(bree).toFilter();
            } else {
                StringBuilder builder = new StringBuilder().append("(|");
                for (String bree : brees.keySet()) {
                    bree = Processor.removeDuplicateMarker(bree);
                    builder.append(EE.parseBREE(bree).toFilter());
                }
                builder.append(')');
                filter = builder.toString();
            }
            Requirement requirement = new CapReqBuilder("osgi.ee").addDirective("filter", filter).buildRequirement();
            reqs.add((Requirement)requirement);
        }
    }

    private void doCapabilities(Domain domain, final List<? super Capability> caps) throws Exception {
        BundleAnalyzer.buildFromHeader(domain.getProvideCapability(), new Yield<CapReqBuilder>(){

            @Override
            public void yield(CapReqBuilder builder) {
                caps.add(builder.buildCapability());
            }
        });
    }

    private void doRequirements(Domain domain, final List<? super Requirement> reqs) throws IOException {
        BundleAnalyzer.buildFromHeader(domain.getRequireCapability(), new Yield<CapReqBuilder>(){

            @Override
            public void yield(CapReqBuilder builder) {
                reqs.add(builder.buildRequirement());
            }
        });
    }

    private void doBundleNativeCode(Domain domain, List<? super Requirement> reqs) throws IOException {
        Object builder;
        String filter;
        Parameters nativeHeader = new Parameters(domain.get("Bundle-NativeCode"));
        if (nativeHeader.isEmpty()) {
            return;
        }
        boolean optional = false;
        LinkedList<String> options = new LinkedList<String>();
        for (Map.Entry<String, Attrs> entry : nativeHeader.entrySet()) {
            String selectionFilter;
            String languageFilter;
            String processorFilter;
            String versionRangeStr;
            String name = entry.getKey();
            if ("*".equals(name)) {
                optional = true;
                continue;
            }
            StringBuilder builder2 = new StringBuilder().append("(&");
            Map attribs = entry.getValue();
            String osnamesFilter = this.buildFilter(attribs, "osname", "osgi.native.osname");
            if (osnamesFilter != null) {
                builder2.append(osnamesFilter);
            }
            if ((versionRangeStr = (String)attribs.get("osversion")) != null) {
                VersionRange range = new VersionRange(versionRangeStr);
                builder2.append(range.toFilter());
            }
            if ((processorFilter = this.buildFilter(attribs, "processor", "osgi.native.processor")) != null) {
                builder2.append(processorFilter);
            }
            if ((languageFilter = this.buildFilter(attribs, "language", "osgi.native.language")) != null) {
                builder2.append(languageFilter);
            }
            if ((selectionFilter = (String)attribs.get("selection-filter")) != null) {
                builder2.append(selectionFilter);
            }
            builder2.append(")");
            options.add(builder2.toString());
        }
        if (options.isEmpty()) {
            return;
        }
        if (options.size() == 1) {
            filter = (String)options.get(0);
        } else {
            builder = new StringBuilder();
            ((StringBuilder)builder).append("(|");
            for (String option : options) {
                ((StringBuilder)builder).append(option);
            }
            ((StringBuilder)builder).append(")");
            filter = ((StringBuilder)builder).toString();
        }
        builder = new CapReqBuilder("osgi.native").addDirective("filter", filter);
        if (optional) {
            ((CapReqBuilder)builder).addDirective("resolution", "optional");
        }
        reqs.add((Requirement)((CapReqBuilder)builder).buildRequirement());
    }

    private String buildFilter(Map<String, String> attribs, String match, String filterKey) {
        LinkedList<String> options = new LinkedList<String>();
        for (Map.Entry<String, String> entry : attribs.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            if (!match.equals(key)) continue;
            String filter = String.format("(%s~=%s)", filterKey, entry.getValue());
            options.add(filter);
        }
        if (options.isEmpty()) {
            return null;
        }
        if (options.size() == 1) {
            return (String)options.get(0);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(|");
        for (String option : options) {
            builder.append(option);
        }
        builder.append(")");
        return builder.toString();
    }

    private static void buildFromHeader(Parameters p, Yield<CapReqBuilder> output) {
        for (Map.Entry<String, Attrs> entry : p.entrySet()) {
            String namespace = Processor.removeDuplicateMarker(entry.getKey());
            CapReqBuilder builder = new CapReqBuilder(namespace);
            BundleAnalyzer.copyAttribsToBuilder(builder, entry.getValue());
            output.yield(builder);
        }
    }

    public static void copyAttribsToBuilder(CapReqBuilder builder, Attrs attribs) {
        for (Map.Entry<String, String> attrib : attribs.entrySet()) {
            String key = attrib.getKey();
            if (key.endsWith(":")) {
                String directiveName = key.substring(0, key.length() - 1);
                builder.addDirective(directiveName, attrib.getValue());
                continue;
            }
            Attrs.Type type = attribs.getType(key);
            Object value = attribs.getTyped(key);
            builder.addAttribute(key, value);
        }
    }
}

