/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.console.history.PersistentHistory;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.console.Branding;
import org.apache.karaf.shell.impl.console.CommandNamesCompleter;
import org.apache.karaf.shell.impl.console.CommandsCompleter;
import org.apache.karaf.shell.impl.console.CompleterAsCompletor;
import org.apache.karaf.shell.impl.console.HistoryWrapper;
import org.apache.karaf.shell.impl.console.JLineTerminal;
import org.apache.karaf.shell.impl.console.KarafFileHistory;
import org.apache.karaf.shell.impl.console.KarafTerminal;
import org.apache.karaf.shell.impl.console.RegistryImpl;
import org.apache.karaf.shell.impl.console.parsing.CommandLineParser;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.FileOrUriCompleter;
import org.apache.karaf.shell.support.completers.UriCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSessionImpl
implements Session {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String SHELL_HISTORY_MAXSIZE = "karaf.shell.history.maxSize";
    public static final String PROMPT = "PROMPT";
    public static final String DEFAULT_PROMPT = "\u001b[1m${USER}\u001b[0m@${APPLICATION}(${SUBSHELL})> ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleSessionImpl.class);
    final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);
    final ConsoleInputStream console = new ConsoleInputStream();
    final Pipe pipe = new Pipe();
    volatile boolean running;
    volatile boolean eof;
    final SessionFactory factory;
    final ThreadIO threadIO;
    final InputStream in;
    final PrintStream out;
    final PrintStream err;
    private Runnable closeCallback;
    final CommandSession session;
    final Registry registry;
    final Terminal terminal;
    final org.apache.karaf.shell.api.console.History history;
    final ConsoleReader reader;
    private boolean interrupt;
    private Thread thread;

    public ConsoleSessionImpl(SessionFactory factory, CommandProcessor processor, ThreadIO threadIO, InputStream in, PrintStream out, PrintStream err, Terminal term, String encoding, Runnable closeCallback) {
        String maxSizeStr;
        this.factory = factory;
        this.threadIO = threadIO;
        this.in = in;
        this.out = out;
        this.err = err;
        this.closeCallback = closeCallback;
        this.terminal = term == null ? new JLineTerminal((jline.Terminal)new UnsupportedTerminal(), "dumb") : term;
        try {
            System.setProperty("jline.sigcont", "true");
            this.reader = new ConsoleReader(null, (InputStream)(in != null ? this.console : null), (OutputStream)out, (jline.Terminal)(this.terminal instanceof JLineTerminal ? ((JLineTerminal)this.terminal).getTerminal() : new KarafTerminal(this.terminal)), encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening console reader", e);
        }
        File file = this.getHistoryFile();
        try {
            file.getParentFile().mkdirs();
            this.reader.setHistory((History)new KarafFileHistory(file));
        }
        catch (Exception e) {
            LOGGER.error("Can not read history from file " + file + ". Using in memory history", (Throwable)e);
        }
        if (this.reader.getHistory() instanceof MemoryHistory && (maxSizeStr = System.getProperty(SHELL_HISTORY_MAXSIZE)) != null) {
            ((MemoryHistory)this.reader.getHistory()).setMaxSize(Integer.parseInt(maxSizeStr));
        }
        this.history = new HistoryWrapper(this.reader.getHistory());
        this.registry = new RegistryImpl(factory.getRegistry());
        this.registry.register(factory);
        this.registry.register(this);
        this.registry.register(this.registry);
        this.registry.register(this.terminal);
        this.registry.register(this.history);
        CommandsCompleter completer = new CommandsCompleter(factory);
        this.reader.addCompleter((Completer)new CompleterAsCompletor(this, completer));
        this.registry.register(completer);
        this.registry.register(new CommandNamesCompleter());
        this.registry.register(new FileCompleter());
        this.registry.register(new UriCompleter());
        this.registry.register(new FileOrUriCompleter());
        this.session = processor.createSession(in != null ? this.console : null, out, err);
        Properties sysProps = System.getProperties();
        for (Object key : sysProps.keySet()) {
            this.session.put(key.toString(), sysProps.get(key));
        }
        this.session.put(".session", this);
        this.session.put(".commandSession", this.session);
        this.session.put(".jline.reader", this.reader);
        this.session.put(".jline.terminal", this.reader.getTerminal());
        this.session.put(".jline.history", this.reader.getHistory());
        this.session.put("SCOPE", "shell:bundle:*");
        this.session.put("SUBSHELL", "");
        this.session.put("karaf.completionMode", this.loadCompletionMode());
        this.session.put("USER", ShellUtil.getCurrentUserName());
        this.session.put("TERM", this.terminal.getType());
        this.session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        this.session.put("#LINES", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(ConsoleSessionImpl.this.terminal.getHeight());
            }
        });
        this.session.put("#COLUMNS", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(ConsoleSessionImpl.this.terminal.getWidth());
            }
        });
        this.session.put("pid", this.getPid());
    }

    protected File getHistoryFile() {
        String defaultHistoryPath = new File(System.getProperty("user.home"), ".karaf/karaf.history").toString();
        return new File(System.getProperty("karaf.history", defaultHistoryPath));
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public org.apache.karaf.shell.api.console.History getHistory() {
        return this.history;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    @Override
    public void close() {
        if (!this.running) {
            return;
        }
        this.out.println();
        if (this.reader.getHistory() instanceof PersistentHistory) {
            try {
                ((PersistentHistory)this.reader.getHistory()).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.running = false;
        this.pipe.interrupt();
        if (this.thread != Thread.currentThread()) {
            this.thread.interrupt();
        }
        this.reader.shutdown();
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
        if (this.terminal instanceof Closeable) {
            try {
                ((Closeable)((Object)this.terminal)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.threadIO.setStreams(this.session.getKeyboard(), this.out, this.err);
            this.thread = Thread.currentThread();
            this.running = true;
            this.pipe.start();
            Properties brandingProps = Branding.loadBrandingProperties(this.terminal);
            this.welcome(brandingProps);
            this.setSessionProperties(brandingProps);
            String scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
            this.executeScript(scriptFileName);
            while (this.running) {
                try {
                    String command = this.readAndParseCommand();
                    if (command == null) break;
                    Object result = this.session.execute(command);
                    if (result == null) continue;
                    this.session.getConsole().println(this.session.format(result, 0));
                }
                catch (InterruptedIOException command) {
                }
                catch (InterruptedException command) {
                }
                catch (Throwable t) {
                    ShellUtil.logException(this, t);
                }
            }
            this.close();
        }
        finally {
            try {
                this.threadIO.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public Object execute(CharSequence commandline) throws Exception {
        String command = CommandLineParser.parse(this, commandline.toString());
        return this.session.execute(command);
    }

    @Override
    public Object get(String name) {
        return this.session.get(name);
    }

    @Override
    public void put(String name, Object value) {
        this.session.put(name, value);
    }

    @Override
    public InputStream getKeyboard() {
        return this.session.getKeyboard();
    }

    @Override
    public PrintStream getConsole() {
        return this.session.getConsole();
    }

    @Override
    public String resolveCommand(String name) {
        if (!name.contains(":")) {
            String[] scopes = ((String)this.get("SCOPE")).split(":");
            List<Command> commands = this.registry.getCommands();
            for (String scope : scopes) {
                for (Command command : commands) {
                    if (!"*".equals(scope) && !command.getScope().equals(scope) || !command.getName().equals(name)) continue;
                    return command.getScope() + ":" + name;
                }
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(String prompt, Character mask) throws IOException {
        this.reader.setHistoryEnabled(false);
        try {
            String string = this.reader.readLine(prompt, mask);
            return string;
        }
        finally {
            this.reader.setHistoryEnabled(true);
        }
    }

    private String loadCompletionMode() {
        String mode;
        try {
            File shellCfg = new File(System.getProperty("karaf.etc"), "/org.apache.karaf.shell.cfg");
            Properties properties = new Properties();
            properties.load(new FileInputStream(shellCfg));
            mode = (String)properties.get("completionMode");
            if (mode == null) {
                LOGGER.debug("completionMode property is not defined in etc/org.apache.karaf.shell.cfg file. Using default completion mode.");
                mode = "global";
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't read {}/org.apache.karaf.shell.cfg file. The completion is set to default.", (Object)System.getProperty("karaf.etc"));
            mode = "global";
        }
        return mode;
    }

    private String readAndParseCommand() throws IOException {
        String command = null;
        boolean first = true;
        while (true) {
            this.checkInterrupt();
            String line = this.reader.readLine(first ? this.getPrompt() : "> ");
            if (line == null) {
                return null;
            }
            command = command == null ? line : (command.charAt(command.length() - 1) == '\\' ? command.substring(0, command.length() - 1) + line : command + "\n" + line);
            if (this.reader.getHistory().size() == 0) {
                this.reader.getHistory().add((CharSequence)command);
            } else if (command.length() > 0 && !" ".equals(command)) {
                this.reader.getHistory().replace((CharSequence)command);
            }
            if (command.length() > 0 && command.charAt(command.length() - 1) == '\\') {
                first = false;
                continue;
            }
            try {
                return CommandLineParser.parse(this, command);
            }
            catch (Exception e) {
                first = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String scriptFileName) {
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                this.session.execute(new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
                System.err.println("Error in initialization script: " + e.getMessage());
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void welcome(Properties brandingProps) {
        String welcome = brandingProps.getProperty("welcome");
        if (welcome != null && welcome.length() > 0) {
            this.session.getConsole().println(welcome);
        }
    }

    protected void setSessionProperties(Properties brandingProps) {
        for (Map.Entry<Object, Object> entry : brandingProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("session.")) continue;
            this.session.put(key.substring("session.".length()), entry.getValue());
        }
    }

    protected String getPrompt() {
        try {
            String prompt;
            try {
                Object p = this.session.get(PROMPT);
                if (p != null) {
                    prompt = p.toString();
                } else {
                    Properties properties = Branding.loadBrandingProperties(this.terminal);
                    if (properties.getProperty("prompt") != null) {
                        prompt = properties.getProperty("prompt");
                        this.session.put(PROMPT, prompt);
                    } else {
                        prompt = DEFAULT_PROMPT;
                    }
                }
            }
            catch (Throwable t) {
                prompt = DEFAULT_PROMPT;
            }
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(prompt);
            while (matcher.find()) {
                Object rep = this.session.get(matcher.group(1));
                if (rep == null) continue;
                prompt = prompt.replace(matcher.group(0), rep.toString());
                matcher.reset(prompt);
            }
            return prompt;
        }
        catch (Throwable t) {
            return "$ ";
        }
    }

    private void checkInterrupt() throws IOException {
        if (Thread.interrupted() || this.interrupt) {
            this.interrupt = false;
            throw new InterruptedIOException("Keyboard interruption");
        }
    }

    private void interrupt() {
        this.interrupt = true;
        this.thread.interrupt();
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    static /* synthetic */ void access$200(ConsoleSessionImpl x0) {
        x0.interrupt();
    }

    private class Pipe
    extends Thread {
        public Pipe() {
            super("Karaf shell pipe thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            useAvailable = System.getProperty("os.name").toLowerCase().contains("windows") == false;
            while (true) {
                try {
                    if (!ConsoleSessionImpl.this.running) break;
lbl5:
                    // 2 sources

                    while (true) {
                        try {
                            if (!useAvailable || ConsoleSessionImpl.this.in.available() != 0) ** GOTO lbl37
                            if (!ConsoleSessionImpl.this.running) {
                                ConsoleSessionImpl.this.eof = true;
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable t) {
                            ConsoleSessionImpl.this.eof = true;
                            try {
                                ConsoleSessionImpl.this.queue.put(-1);
                                return;
                            }
                            catch (InterruptedException var3_8) {
                                // empty catch block
                            }
                            return;
                        }
                        break;
                    }
                }
                catch (Throwable var4_9) {
                    ConsoleSessionImpl.this.eof = true;
                    try {
                        ConsoleSessionImpl.this.queue.put(-1);
                        throw var4_9;
                    }
                    catch (InterruptedException var5_10) {
                        // empty catch block
                    }
                    throw var4_9;
                }
                try {
                    ConsoleSessionImpl.this.queue.put(-1);
                    return;
                }
                catch (InterruptedException var2_3) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    Thread.sleep(50L);
                    ** continue;
lbl37:
                    // 1 sources

                    c = ConsoleSessionImpl.this.in.read();
                    if (c != -1) ** GOTO lbl-1000
                    ConsoleSessionImpl.this.eof = true;
                }
                try {
                    ConsoleSessionImpl.this.queue.put(-1);
                    return;
                }
                catch (InterruptedException var3_6) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    if (c != 4 || ShellUtil.getBoolean(ConsoleSessionImpl.this, "karaf.ignoreInterrupts")) ** GOTO lbl-1000
                    ConsoleSessionImpl.this.err.print("^D");
                    ConsoleSessionImpl.this.err.flush();
                    ConsoleSessionImpl.access$200(ConsoleSessionImpl.this);
                    ConsoleSessionImpl.this.eof = true;
                }
                try {
                    ConsoleSessionImpl.this.queue.put(-1);
                    return;
                }
                catch (InterruptedException var3_7) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    if (c == 3 && !ShellUtil.getBoolean(ConsoleSessionImpl.this, "karaf.ignoreInterrupts")) {
                        ConsoleSessionImpl.this.err.println("^C");
                        ConsoleSessionImpl.this.reader.getCursorBuffer().clear();
                        ConsoleSessionImpl.access$200(ConsoleSessionImpl.this);
                    }
                    ConsoleSessionImpl.this.queue.put(c);
                    continue;
                }
                break;
            }
            ConsoleSessionImpl.this.eof = true;
            try {
                ConsoleSessionImpl.this.queue.put(-1);
                return;
            }
            catch (InterruptedException var2_5) {
                return;
            }
        }
    }

    private class ConsoleInputStream
    extends InputStream {
        private ConsoleInputStream() {
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (!ConsoleSessionImpl.this.running) {
                return -1;
            }
            ConsoleSessionImpl.this.checkInterrupt();
            if (ConsoleSessionImpl.this.eof && ConsoleSessionImpl.this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = ConsoleSessionImpl.this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                ConsoleSessionImpl.this.checkInterrupt();
            } else {
                i = (Integer)ConsoleSessionImpl.this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        @Override
        public int read() throws IOException {
            return this.read(true);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        @Override
        public int available() throws IOException {
            return ConsoleSessionImpl.this.queue.size();
        }
    }
}

