/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.internal.BufferingLog;
import org.ops4j.pax.logging.internal.DefaultServiceLog;
import org.osgi.framework.Bundle;

public class FallbackLogFactory {
    public static PaxLogger createFallbackLog(Bundle bundle, String categoryName) {
        if (FallbackLogFactory.isBuffering()) {
            return new BufferingLog(bundle, categoryName);
        }
        return new DefaultServiceLog(bundle, categoryName);
    }

    private static boolean isBuffering() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("org.ops4j.pax.logging.useBufferingLogFallback");
                }
            });
        }
        return Boolean.getBoolean("org.ops4j.pax.logging.useBufferingLogFallback");
    }
}

