/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.apache.karaf.bundle.core.internal.BundleInfoImpl;
import org.apache.karaf.bundle.core.internal.BundleSelectorImpl;
import org.apache.karaf.util.jaas.JaasHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleServiceImpl
implements BundleService {
    private static Logger LOG = LoggerFactory.getLogger(BundleService.class);
    private static final String ORIGINAL_WIRES = "Original-Wires";
    private final BundleContext bundleContext;
    private final List<BundleStateService> stateServices = new CopyOnWriteArrayList<BundleStateService>();

    public BundleServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void registerBundleStateService(BundleStateService service) {
        this.stateServices.add(service);
    }

    public void unregisterBundleStateService(BundleStateService service) {
        this.stateServices.remove(service);
    }

    @Override
    public List<Bundle> selectBundles(List<String> ids, boolean defaultAllBundles) {
        return this.selectBundles(null, ids, defaultAllBundles);
    }

    @Override
    public List<Bundle> selectBundles(String context, List<String> ids, boolean defaultAllBundles) {
        return this.doSelectBundles(this.doGetBundleContext(context), ids, defaultAllBundles);
    }

    @Override
    public Bundle getBundle(String id) {
        return this.getBundle(null, id);
    }

    @Override
    public Bundle getBundle(String context, String id) {
        return this.doGetBundle(this.doGetBundleContext(context), id);
    }

    @Override
    public BundleInfo getInfo(Bundle bundle) {
        BundleState combinedState = BundleState.Unknown;
        for (BundleStateService stateService : this.stateServices) {
            BundleState extState = stateService.getState(bundle);
            if (extState == BundleState.Unknown) continue;
            combinedState = extState;
        }
        return new BundleInfoImpl(bundle, combinedState);
    }

    @Override
    public String getDiag(Bundle bundle) {
        StringBuilder message = new StringBuilder();
        for (BundleStateService bundleStateService : this.stateServices) {
            String part = bundleStateService.getDiag(bundle);
            if (part == null) continue;
            message.append(bundleStateService.getName());
            message.append("\n");
            message.append(part);
        }
        if (bundle.getState() == 2) {
            System.out.println("Unsatisfied Requirements:");
            List<BundleRequirement> reqs = this.getUnsatisfiedRequirements(bundle, null);
            for (BundleRequirement req : reqs) {
                System.out.println(req);
            }
        }
        return message.toString();
    }

    @Override
    public List<BundleRequirement> getUnsatisfiedRequirements(Bundle bundle, String namespace) {
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null) {
            List reqs = rev.getDeclaredRequirements(namespace);
            for (BundleRequirement req : reqs) {
                if (this.canBeSatisfied(req)) continue;
                result.add(req);
            }
        }
        return result;
    }

    @Override
    public int getSystemBundleThreshold() {
        int sbsl = 50;
        try {
            String sbslProp = this.bundleContext.getProperty("karaf.systemBundlesStartLevel");
            if (sbslProp != null) {
                sbsl = Integer.valueOf(sbslProp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sbsl;
    }

    private BundleContext doGetBundleContext(String context) {
        if (context == null || context.trim().isEmpty()) {
            return this.bundleContext;
        }
        List<Bundle> bundles = new BundleSelectorImpl(this.bundleContext).selectBundles(Collections.singletonList(context), false);
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("Context " + context + " does not evaluate to a bundle");
        }
        if (bundles.size() > 1) {
            throw new IllegalArgumentException("Context " + context + " is ambiguous");
        }
        BundleContext bundleContext = bundles.get(0).getBundleContext();
        if (bundleContext == null) {
            throw new IllegalArgumentException("Context " + context + " is not resolved");
        }
        return bundleContext;
    }

    private Bundle doGetBundle(BundleContext bundleContext, String id) {
        List<Bundle> bundles = this.doSelectBundles(bundleContext, Collections.singletonList(id), false);
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("Bundle " + id + " does not match any bundle");
        }
        List<Bundle> filtered = this.filter(bundles);
        if (filtered.isEmpty()) {
            throw new IllegalArgumentException("Access to bundle " + id + " is forbidden");
        }
        if (filtered.size() > 1) {
            throw new IllegalArgumentException("Multiple bundles matching " + id);
        }
        return filtered.get(0);
    }

    private List<Bundle> doSelectBundles(BundleContext bundleContext, List<String> ids, boolean defaultAllBundles) {
        return this.filter(new BundleSelectorImpl(bundleContext).selectBundles(ids, defaultAllBundles));
    }

    private List<Bundle> filter(List<Bundle> bundles) {
        if (JaasHelper.currentUserHasRole("systembundles")) {
            return bundles;
        }
        int sbsl = this.getSystemBundleThreshold();
        ArrayList<Bundle> filtered = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            if (level < sbsl) continue;
            filtered.add(bundle);
        }
        return filtered;
    }

    private boolean canBeSatisfied(BundleRequirement req) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring == null) continue;
            List caps = wiring.getCapabilities(null);
            for (BundleCapability cap : caps) {
                if (!req.matches(cap)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void enableDynamicImports(Bundle bundle) {
        String location = String.format("wrap:%s$Bundle-UpdateLocation=%s&DynamicImport-Package=*&%s=%s&overwrite=merge", bundle.getLocation(), bundle.getLocation(), ORIGINAL_WIRES, this.explode(this.getWiredBundles(bundle).keySet()));
        LOG.debug(String.format("Updating %s with URL %s", bundle, location));
        try {
            URL url = new URL(location);
            bundle.update(url.openStream());
            ((FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class)).refreshBundles(Collections.singleton(bundle), new FrameworkListener[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error enabling dynamic imports on bundle" + bundle.getBundleId(), e);
        }
    }

    @Override
    public void disableDynamicImports(Bundle bundle) {
        Set<String> current = this.getWiredBundles(bundle).keySet();
        for (String original : ((String)bundle.getHeaders().get(ORIGINAL_WIRES)).split(",")) {
            current.remove(original);
        }
        if (current.isEmpty()) {
            LOG.debug("No additional packages have been wired since dynamic import was enabled");
        } else {
            LOG.debug("Additional packages wired since dynamic import was enabled");
            for (String pkg : current) {
                LOG.debug("- " + pkg);
            }
        }
        try {
            bundle.update();
        }
        catch (BundleException e) {
            throw new RuntimeException("Error disabling dynamic imports on bundle" + bundle.getBundleId(), e);
        }
    }

    private String explode(Set<String> set) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(",");
        }
        if (result.length() == 0) {
            return "--none--";
        }
        return result.toString();
    }

    @Override
    public Map<String, Bundle> getWiredBundles(Bundle bundle) {
        HashMap<String, Bundle> exporters = new HashMap<String, Bundle>();
        for (BundleRevision revision : ((BundleRevisions)bundle.adapt(BundleRevisions.class)).getRevisions()) {
            List wires;
            BundleWiring wiring = revision.getWiring();
            if (wiring == null || (wires = wiring.getRequiredWires("osgi.wiring.package")) == null) continue;
            for (BundleWire wire : wires) {
                if (wire.getProviderWiring().getBundle().getBundleId() == 0L) continue;
                exporters.put(wire.getCapability().getAttributes().get("osgi.wiring.package").toString(), wire.getProviderWiring().getBundle());
            }
        }
        return exporters;
    }

    @Override
    public boolean isDynamicImport(Bundle bundle) {
        return bundle.getHeaders().get(ORIGINAL_WIRES) != null;
    }

    @Override
    public String getStatus(String id) {
        Bundle bundle = this.getBundle(id);
        return this.getState(bundle);
    }

    private String getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 32: {
                return "Active";
            }
        }
        return "Unknown";
    }
}

