/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class OrRule
extends AbstractRule {
    static final long serialVersionUID = 2088765995061413165L;
    private final Rule rule1;
    private final Rule rule2;

    private OrRule(Rule firstParam, Rule secondParam) {
        this.rule1 = firstParam;
        this.rule2 = secondParam;
    }

    public static Rule getRule(Rule firstParam, Rule secondParam) {
        return new OrRule(firstParam, secondParam);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid OR rule - expected two rules but received " + stack.size());
        }
        Object o2 = stack.pop();
        Object o1 = stack.pop();
        if (o2 instanceof Rule && o1 instanceof Rule) {
            Rule p2 = (Rule)o2;
            Rule p1 = (Rule)o1;
            return new OrRule(p1, p2);
        }
        throw new IllegalArgumentException("Invalid OR rule: " + o2 + "..." + o1);
    }

    @Override
    public boolean evaluate(LoggingEvent event, Map matches) {
        boolean result;
        if (matches == null) {
            return this.rule1.evaluate(event, null) || this.rule2.evaluate(event, null);
        }
        HashMap tempMatches1 = new HashMap();
        HashMap tempMatches2 = new HashMap();
        boolean result1 = this.rule1.evaluate(event, tempMatches1);
        boolean result2 = this.rule2.evaluate(event, tempMatches2);
        boolean bl = result = result1 || result2;
        if (result) {
            Set mainSet;
            Set value;
            Object key;
            for (Map.Entry entry : tempMatches1.entrySet()) {
                key = entry.getKey();
                value = (Set)entry.getValue();
                mainSet = (HashSet)matches.get(key);
                if (mainSet == null) {
                    mainSet = new HashSet();
                    matches.put(key, mainSet);
                }
                mainSet.addAll(value);
            }
            for (Map.Entry entry : tempMatches2.entrySet()) {
                key = entry.getKey();
                value = (Set)entry.getValue();
                mainSet = (Set)matches.get(key);
                if (mainSet == null) {
                    mainSet = new HashSet();
                    matches.put(key, mainSet);
                }
                mainSet.addAll(value);
            }
        }
        return result;
    }
}

