/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;

public class UserAuthFactoriesFactory {
    public static final String PASSWORD_METHOD = "password";
    public static final String PUBLICKEY_METHOD = "publickey";
    public static final String KEYBOARD_INTERACTIVE_METHOD = "keyboard-interactive";
    private Set<String> methodSet;
    private List<NamedFactory<UserAuth>> factories;

    public void setAuthMethods(String methods) {
        String[] ams;
        this.methodSet = new HashSet<String>();
        this.factories = new ArrayList<NamedFactory<UserAuth>>();
        for (String am : ams = methods.split(",")) {
            if (PASSWORD_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthPassword.Factory());
            } else if (KEYBOARD_INTERACTIVE_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthKeyboardInteractive.Factory());
            } else if (PUBLICKEY_METHOD.equals(am)) {
                this.factories.add((NamedFactory<UserAuth>)new UserAuthPublicKey.Factory());
            } else {
                throw new IllegalArgumentException("Invalid authentication method " + am + " specified");
            }
            this.methodSet.add(am);
        }
    }

    public List<NamedFactory<UserAuth>> getFactories() {
        return this.factories;
    }

    public boolean isPublickeyEnabled() {
        return this.methodSet.contains(PUBLICKEY_METHOD);
    }

    public boolean isPasswordEnabled() {
        return this.methodSet.contains(PASSWORD_METHOD);
    }

    public boolean isKeyboardInteractive() {
        return this.methodSet.contains(KEYBOARD_INTERACTIVE_METHOD);
    }
}

