/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx;

import javax.management.MBeanServer;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MBeanServiceTracker
extends ServiceTracker {
    private JMXAgentContext agentContext;

    public MBeanServiceTracker(JMXAgentContext agentContext) {
        super(agentContext.getBundleContext(), MBeanServer.class.getName(), null);
        this.agentContext = agentContext;
    }

    public Object addingService(ServiceReference reference) {
        MBeanServer mbeanServer = (MBeanServer)super.addingService(reference);
        Logger logger = this.agentContext.getLogger();
        logger.log(4, "Discovered MBean server " + mbeanServer);
        this.agentContext.registerMBeans(mbeanServer);
        return mbeanServer;
    }

    public void removedService(ServiceReference reference, Object service) {
        MBeanServer mbeanServer = (MBeanServer)service;
        Logger logger = this.agentContext.getLogger();
        logger.log(4, "MBean server " + mbeanServer + " is unregistered from ServiceRegistry");
        this.agentContext.unregisterMBeans(mbeanServer);
        super.removedService(reference, service);
    }
}

