/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi.secured;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.service.guard.tools.ACLConfigurationParser;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.console.SessionFactoryImpl;
import org.apache.karaf.shell.impl.console.osgi.secured.SecuredCommand;
import org.apache.karaf.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredSessionFactoryImpl
extends SessionFactoryImpl
implements ConfigurationListener,
SingleServiceTracker.SingleServiceListener {
    private static final String PROXY_COMMAND_ACL_PID_PREFIX = "org.apache.karaf.command.acl.";
    private static final String CONFIGURATION_FILTER = "(service.pid=org.apache.karaf.command.acl.*)";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredSessionFactoryImpl.class);
    private BundleContext bundleContext;
    private Map<String, Dictionary<String, Object>> scopes = new HashMap<String, Dictionary<String, Object>>();
    private SingleServiceTracker<ConfigurationAdmin> configAdminTracker;
    private ServiceRegistration registration;

    public SecuredSessionFactoryImpl(BundleContext bundleContext, ThreadIO threadIO) throws InvalidSyntaxException {
        super(threadIO);
        this.bundleContext = bundleContext;
        this.registration = bundleContext.registerService(ConfigurationListener.class, (Object)this, null);
        this.configAdminTracker = new SingleServiceTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class, this);
        this.configAdminTracker.open();
    }

    @Override
    public void stop() {
        this.registration.unregister();
        this.configAdminTracker.close();
        super.stop();
    }

    @Override
    protected Function wrap(Command command) {
        return new SecuredCommand(this, command);
    }

    @Override
    protected boolean isVisible(Object service) {
        if (service instanceof Command) {
            return this.isVisible((Command)service);
        }
        return super.isVisible(service);
    }

    protected boolean isVisible(Command command) {
        Dictionary<String, Object> config = this.getScopeConfig(command.getScope());
        if (config != null) {
            ArrayList<String> roles = new ArrayList<String>();
            ACLConfigurationParser.getRolesForInvocation(command.getName(), null, null, config, roles);
            if (roles.isEmpty()) {
                return true;
            }
            for (String role : roles) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    void checkSecurity(SecuredCommand command, Session session, List<Object> arguments) {
        Dictionary<String, Object> config = this.getScopeConfig(command.getScope());
        if (config != null) {
            if (!this.isVisible(command)) {
                throw new CommandNotFoundException(command.getScope() + ":" + command.getName());
            }
            ArrayList<String> roles = new ArrayList<String>();
            ACLConfigurationParser.Specificity s = ACLConfigurationParser.getRolesForInvocation(command.getName(), new Object[]{arguments.toString()}, null, config, roles);
            if (s == ACLConfigurationParser.Specificity.NO_MATCH) {
                return;
            }
            for (String role : roles) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                return;
            }
            throw new SecurityException("Insufficient credentials.");
        }
    }

    static boolean currentUserHasRole(String requestedRole) {
        String role;
        String clazz;
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = RolePrincipal.class.getName();
            role = requestedRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (!event.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        try {
            switch (event.getType()) {
                case 2: {
                    this.removeScopeConfig(event.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length()));
                    break;
                }
                case 1: {
                    ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(event.getReference());
                    try {
                        this.addScopeConfig(configAdmin.getConfiguration(event.getPid(), null));
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(event.getReference());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem processing Configuration Event {}", (Object)event, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScopeConfig(Configuration config) {
        if (!config.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        String scope = config.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length());
        if (scope.indexOf(46) >= 0) {
            return;
        }
        scope = scope.trim();
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            this.scopes.put(scope, config.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScopeConfig(String scope) {
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            this.scopes.remove(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getScopeConfig(String scope) {
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            return this.scopes.get(scope);
        }
    }

    @Override
    public void serviceFound() {
        try {
            ConfigurationAdmin configAdmin = this.configAdminTracker.getService();
            Configuration[] configs = configAdmin.listConfigurations(CONFIGURATION_FILTER);
            if (configs != null) {
                for (Configuration config : configs) {
                    this.addScopeConfig(config);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serviceLost() {
    }

    @Override
    public void serviceReplaced() {
        this.serviceFound();
    }
}

