/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ExistsRule
extends AbstractRule {
    static final long serialVersionUID = -5386265224649967464L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private final String field;

    private ExistsRule(String fld) {
        if (!RESOLVER.isField(fld)) {
            throw new IllegalArgumentException("Invalid EXISTS rule - " + fld + " is not a supported field");
        }
        this.field = fld;
    }

    public static Rule getRule(String field) {
        return new ExistsRule(field);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("Invalid EXISTS rule - expected one parameter but received " + stack.size());
        }
        return new ExistsRule(stack.pop().toString());
    }

    @Override
    public boolean evaluate(LoggingEvent event, Map matches) {
        boolean result;
        Object p2 = RESOLVER.getValue(this.field, event);
        boolean bl = result = p2 != null && !p2.toString().equals("");
        if (result && matches != null) {
            HashSet<Object> entries = (HashSet<Object>)matches.get(this.field.toUpperCase());
            if (entries == null) {
                entries = new HashSet<Object>();
                matches.put(this.field.toUpperCase(), entries);
            }
            entries.add(p2);
        }
        return result;
    }
}

