/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;

public class SocksProxy
extends CloseableUtils.AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map<IoSession, Proxy> proxies = new ConcurrentHashMap<IoSession, Proxy>();

    public SocksProxy(ConnectionService service) {
        this.service = service;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed");
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        Proxy proxy = this.proxies.remove(session);
        if (proxy != null) {
            proxy.close();
        }
    }

    public void messageReceived(IoSession session, Readable message) throws Exception {
        Buffer buffer = new Buffer(message.available());
        buffer.putBuffer(message);
        Proxy proxy = this.proxies.get(session);
        if (proxy == null) {
            byte version = buffer.getByte();
            if (version == 4) {
                proxy = new Socks4(session);
            } else if (version == 5) {
                proxy = new Socks5(session);
            } else {
                throw new IllegalStateException("Unsupported version: " + version);
            }
            proxy.onMessage(buffer);
            this.proxies.put(session, proxy);
        } else {
            proxy.onMessage(buffer);
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        this.log.warn("Exception caught, closing socks proxy", cause);
        ioSession.close(false);
    }

    public class Socks5
    extends Proxy {
        byte[] authMethods;
        Buffer response;

        public Socks5(IoSession session) {
            super(session);
        }

        protected void onMessage(Buffer buffer) throws IOException {
            if (this.authMethods == null) {
                int nbAuthMethods = this.getUByte(buffer);
                this.authMethods = new byte[nbAuthMethods];
                buffer.getRawBytes(this.authMethods);
                boolean foundNoAuth = false;
                for (int i = 0; i < nbAuthMethods; ++i) {
                    foundNoAuth |= this.authMethods[i] == 0;
                }
                buffer = new Buffer(8);
                buffer.putByte((byte)5);
                buffer.putByte((byte)(foundNoAuth ? 0 : 255));
                this.session.write(buffer);
                if (!foundNoAuth) {
                    throw new IllegalStateException("Received socks5 greeting without NoAuth method");
                }
                SocksProxy.this.log.debug("Received socks5 greeting");
            } else if (this.channel == null) {
                String host;
                this.response = buffer;
                int version = this.getUByte(buffer);
                if (version != 5) {
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                byte cmd = buffer.getByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                byte res = buffer.getByte();
                byte type = buffer.getByte();
                if (type == 1) {
                    host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                } else if (type == 3) {
                    host = this.getBLString(buffer);
                } else if (type == 4) {
                    host = Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer));
                } else {
                    throw new IllegalStateException("Unsupported address type: " + type);
                }
                int port = this.getUShort(buffer);
                SocksProxy.this.log.debug("Received socks5 connection request to {}:{}", (Object)host, (Object)port);
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(new SshFutureListener<OpenFuture>(){

                    @Override
                    public void operationComplete(OpenFuture future) {
                        Socks5.this.onChannelOpened(future);
                    }
                });
            } else {
                SocksProxy.this.log.debug("Received socks5 connection message");
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            int wpos = this.response.wpos();
            this.response.rpos(0);
            this.response.wpos(1);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(false);
                this.response.putByte((byte)1);
            } else {
                this.response.putByte((byte)0);
            }
            this.response.wpos(wpos);
            this.session.write(this.response);
        }

        private String getBLString(Buffer buffer) {
            int length = this.getUByte(buffer);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append((char)this.getUByte(buffer));
            }
            return sb.toString();
        }
    }

    public class Socks4
    extends Proxy {
        public Socks4(IoSession session) {
            super(session);
        }

        protected void onMessage(Buffer buffer) throws IOException {
            if (this.channel == null) {
                byte cmd = buffer.getByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int port = this.getUShort(buffer);
                String host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                String userId = this.getNTString(buffer);
                if (host.startsWith("0.0.0.")) {
                    host = this.getNTString(buffer);
                }
                SocksProxy.this.log.debug("Received socks4 connection request to {}:{}", (Object)host, (Object)port);
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(new SshFutureListener<OpenFuture>(){

                    @Override
                    public void operationComplete(OpenFuture future) {
                        Socks4.this.onChannelOpened(future);
                    }
                });
            } else {
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            Buffer buffer = new Buffer(8);
            buffer.putByte((byte)0);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(false);
                buffer.putByte((byte)91);
            } else {
                buffer.putByte((byte)90);
            }
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            buffer.putByte((byte)0);
            this.session.write(buffer);
        }

        private String getNTString(Buffer buffer) {
            char c;
            StringBuilder sb = new StringBuilder();
            while ((c = (char)this.getUByte(buffer)) != '\u0000') {
                sb.append(c);
            }
            return sb.toString();
        }
    }

    public abstract class Proxy {
        IoSession session;
        TcpipClientChannel channel;

        protected Proxy(IoSession session) {
            this.session = session;
        }

        protected void onMessage(Buffer buffer) throws IOException {
            this.channel.getInvertedIn().write(buffer.array(), buffer.rpos(), buffer.available());
            this.channel.getInvertedIn().flush();
        }

        public void close() {
            if (this.channel != null) {
                this.channel.close(false);
            }
        }

        protected int getUByte(Buffer buffer) {
            return buffer.getByte() & 0xFF;
        }

        protected int getUShort(Buffer buffer) {
            return (this.getUByte(buffer) << 8) + this.getUByte(buffer);
        }
    }
}

