/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.interceptor.AsyncExecutionAspectSupport;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class AsyncExecutionInterceptor
extends AsyncExecutionAspectSupport
implements MethodInterceptor,
Ordered {
    public AsyncExecutionInterceptor(Executor executor) {
        super(executor);
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Future result = this.determineAsyncExecutor(invocation.getMethod()).submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result = invocation.proceed();
                    if (result instanceof Future) {
                        return ((Future)result).get();
                    }
                }
                catch (Throwable ex) {
                    ReflectionUtils.rethrowException((Throwable)ex);
                }
                return null;
            }
        });
        if (Future.class.isAssignableFrom(invocation.getMethod().getReturnType())) {
            return result;
        }
        return null;
    }

    protected String getExecutorQualifier(Method method) {
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

